/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.service;

import br.com.elotech.console.client.ConsoleClient;
import br.com.elotech.console.dto.Modulo;
import br.com.elotech.core.enumerable.common.EntidadeTipo;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.di.domain.Entidade;
import br.com.elotech.di.domain.EntidadeCertificado;
import br.com.elotech.di.domain.shared.Arquivo;
import br.com.elotech.di.domain.support.EloDomain;
import br.com.elotech.di.exception.RegistroNaoEncontradoException;
import br.com.elotech.di.repository.Entidades;
import br.com.elotech.di.service.ArquivoServiceImpl;
import br.com.elotech.di.service.support.UnicoCrudService;
import br.com.elotech.di.utils.HeaderUtils;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class EntidadeService
extends UnicoCrudService<Entidade, Long> {
    private static final Long ENTIDADE_DEFAULT = 1L;
    @Autowired
    private ArquivoServiceImpl arquivoService;
    @Autowired
    private Entidades entidades;
    @Autowired
    private ConsoleClient consoleClient;
    @Value(value="${elotech.tenantId:}")
    private String tenantFixo;

    public Optional<Entidade> getEntidadePrincipal() {
        List entidadesPrincipais = this.entidades.findEntidadesPrincipais();
        return entidadesPrincipais.stream().findFirst();
    }

    public Long getEntidadeLogada() {
        String entidade = HeaderUtils.getParamHeaderByKey((String)"entidade");
        if (Objects.isNull(entidade)) {
            return ENTIDADE_DEFAULT;
        }
        return Long.parseLong(entidade);
    }

    public Entidade getObjetoEntidadeLogada() {
        Long entidadeLogada = this.getEntidadeLogada();
        return (Entidade)this.entidades.findById((Object)entidadeLogada).orElseThrow(() -> new RegistroNaoEncontradoException(Entidade.class, entidadeLogada.toString()));
    }

    protected void beforeSave(Entidade entity, Authentication authentication) {
        if (Objects.isNull(entity.getAtivo())) {
            entity.setAtivo(Boolean.TRUE);
        }
        this.checkForEntidadePrincipal(entity);
        EntidadeCertificado entidadeCertificado = Optional.ofNullable(entity.getCertificado()).orElse(new EntidadeCertificado());
        Optional.ofNullable(entidadeCertificado.getArquivo()).ifPresent(a -> {
            Arquivo arquivo = (Arquivo)this.arquivoService.findOne((Serializable)a.getId());
            entity.getCertificado().setArquivo(arquivo);
        });
        if (Objects.nonNull(entity.getTipo()) && !EntidadeTipo.CONSORCIO.equals((Object)entity.getTipo())) {
            entity.getAreasAtuacao().clear();
        }
        super.beforeSave((EloDomain)entity, authentication);
    }

    public Optional<Entidade> findByEntidadeConsole(UUID idEntidadeConsole) {
        return this.entidades.findByEntidadeConsole(idEntidadeConsole);
    }

    private void checkForEntidadePrincipal(Entidade entity) {
        if (entity.isEntidadePrincipal()) {
            Optional entidadePrincipal;
            Object rsql = "entidadePrincipal==true";
            if (!entity.isNew()) {
                rsql = String.format("id!=%s and ", entity.getId()) + (String)rsql;
            }
            if ((entidadePrincipal = this.findByRsql((String)rsql, Pageable.unpaged()).stream().findAny()).isPresent()) {
                throw new EloValidationException(String.format("N\u00e3o \u00e9 permitido mais de uma entidade principal. A entidade %s \u00e9 a principal", ((Entidade)entidadePrincipal.get()).getNome()));
            }
        }
    }

    public String getTenantId() {
        String tenant = this.getTenantIdOrBlank();
        if (StringUtils.isNotBlank((CharSequence)tenant)) {
            return tenant;
        }
        throw new IllegalStateException("N\u00e3o foi poss\u00edvel determinar o Tenant ativo no m\u00f3dulo \u00daNICO!");
    }

    public String getTenantIdOrBlank() {
        if (TenantContextHolder.hasTenant() && StringUtils.isNotBlank((CharSequence)TenantContextHolder.getTenantId().orElse(""))) {
            return TenantContextHolder.getCurrentTenantId();
        }
        if (StringUtils.isNotBlank((CharSequence)this.tenantFixo)) {
            return this.tenantFixo;
        }
        return "";
    }

    public Boolean entidadeLogadaUsaTributos() {
        return Optional.ofNullable(TenantContextHolder.getTenant()).map(tenant -> tenant.getModulos().contains(Modulo.OXY_TRIBUTOS)).orElse(Boolean.FALSE);
    }
}

