/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.service;

import br.com.elotech.di.domain.Duplicacao;
import br.com.elotech.di.domain.dto.duplicacao.DuplicadaDTO;
import br.com.elotech.di.domain.enums.DuplicacaoStatus;
import br.com.elotech.di.repository.DuplicacaoRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class DuplicacaoService {
    public final DuplicacaoRepository repository;

    @Transactional
    public void saveAllDuplicacoes(List<Duplicacao> duplicacoes) {
        this.repository.saveAll(duplicacoes);
    }

    public List<DuplicadaDTO> findAllCidadesDuplicadas(List<DuplicacaoStatus> statusIN) {
        return this.getDuplicadaDTOS(() -> this.repository.findAllCidadesDuplicadasByStatusIn(statusIN));
    }

    public List<DuplicadaDTO> findAllLogradourosDuplicadas(List<DuplicacaoStatus> statusIN) {
        return this.getDuplicadaDTOS(() -> this.repository.findAllLogradourosDuplicadasByStatusIn(statusIN));
    }

    public List<DuplicadaDTO> findAllBairrosDuplicadas(List<DuplicacaoStatus> statusIN) {
        return this.getDuplicadaDTOS(() -> this.repository.findAllBairrosDuplicadosByStatusIn(statusIN));
    }

    private List<DuplicadaDTO> getDuplicadaDTOS(Supplier<List<DuplicadaDTO>> repositoryFunction) {
        ArrayList<DuplicadaDTO> duplicadaDTOS = new ArrayList<DuplicadaDTO>();
        Map<Long, List<DuplicadaDTO>> duplicadosAgrupadasPorChavePrincipal = repositoryFunction.get().stream().collect(Collectors.groupingBy(DuplicadaDTO::getChavePrincipal));
        duplicadosAgrupadasPorChavePrincipal.forEach((chavePrincipal, dtoList) -> {
            DuplicadaDTO duplicadaDTO = new DuplicadaDTO();
            DuplicadaDTO dto = (DuplicadaDTO)dtoList.get(0);
            duplicadaDTO.setChavePrincipal(chavePrincipal);
            duplicadaDTO.setStatus(dto.getStatus());
            duplicadaDTO.setErro(dto.getErro());
            duplicadaDTO.setDescricaoPrincipal(dto.getDescricaoPrincipal());
            duplicadaDTO.getDuplicacoes().addAll(dtoList);
            duplicadaDTOS.add(duplicadaDTO);
        });
        return duplicadaDTOS;
    }

    @Transactional
    public void updateExecutado(List<Long> idsDuplicacoes) {
        this.repository.updateExecutadoByIdIn(idsDuplicacoes);
    }

    @Transactional
    public void removeWithChavePrincipal(String tabela, Long chavePrincipal) {
        this.repository.removeWithChavePrincipal(tabela, chavePrincipal);
    }

    @Transactional
    public void removeWithChaveInativa(String tabela, Long chaveInativa) {
        this.repository.removeWithChaveInativa(tabela, chaveInativa);
    }

    @Transactional
    public void updateExecutando(List<Long> idsDuplicacoes) {
        this.repository.updateExecutandoByIdIn(idsDuplicacoes);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void updateFalha(List<Long> idsDuplicacoes, String erro) {
        this.repository.updateFalhaByIdIn(idsDuplicacoes, erro);
    }

    public List<DuplicadaDTO> findAllCidadesDuplicadasExecucao() {
        return this.findAllCidadesDuplicadas(List.of(DuplicacaoStatus.PROCESSANDO));
    }

    public List<DuplicadaDTO> findAllCidadesDuplicadasNotExecutado() {
        return this.findAllCidadesDuplicadas(DuplicacaoStatus.NAO_EXECUTADO);
    }

    public List<DuplicadaDTO> findAllCidadesDuplicadasExecutado() {
        return this.findAllCidadesDuplicadas(DuplicacaoStatus.EXECUTADO);
    }

    public List<DuplicadaDTO> findAllLogradourosDuplicadasExecucao() {
        return this.findAllLogradourosDuplicadas(List.of(DuplicacaoStatus.PROCESSANDO));
    }

    public List<DuplicadaDTO> findAllLogradourosDuplicadasNotExecutado() {
        return this.findAllLogradourosDuplicadas(DuplicacaoStatus.NAO_EXECUTADO);
    }

    public List<DuplicadaDTO> findAllLogradourosDuplicadasExecutado() {
        return this.findAllLogradourosDuplicadas(DuplicacaoStatus.EXECUTADO);
    }

    public List<DuplicadaDTO> findAllBairrosDuplicadasNotExecutado() {
        return this.findAllBairrosDuplicadas(DuplicacaoStatus.NAO_EXECUTADO);
    }

    public List<DuplicadaDTO> findAllBairrosDuplicadasExecutado() {
        return this.findAllBairrosDuplicadas(DuplicacaoStatus.EXECUTADO);
    }

    public List<DuplicadaDTO> findAllBairrosDuplicadasExecucao() {
        return this.findAllBairrosDuplicadas(List.of(DuplicacaoStatus.PROCESSANDO));
    }

    @Generated
    public DuplicacaoService(DuplicacaoRepository repository) {
        this.repository = repository;
    }
}

