/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.di.domain.DocumentoPessoa;
import br.com.elotech.di.domain.shared.Arquivo;
import br.com.elotech.di.service.ArquivoServiceImpl;
import br.com.elotech.di.service.CrudServicePessoaInverse;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class DocumentoPessoaService
extends CrudServicePessoaInverse<DocumentoPessoa, Long> {
    @Autowired
    private final ArquivoServiceImpl arquivoService;

    public DocumentoPessoaService(ArquivoServiceImpl arquivoService) {
        this.arquivoService = arquivoService;
    }

    public DocumentoPessoa save(DocumentoPessoa entity, Authentication authentication) {
        DocumentoPessoa entityUpdated = entity;
        if (Objects.nonNull(entity.getId())) {
            entityUpdated = (DocumentoPessoa)this.findById((Serializable)entity.getId()).get();
        } else {
            List pessoaDocumentos = this.findAll(Specification.where((Specification)this.docAlreadyExists(entity.getPessoa().getId(), entity.getDoc().getDocumento().getId(), entity.getDoc().getNumeroDocumento(), entity.getDoc().getDataEmissao())));
            if (!pessoaDocumentos.isEmpty()) {
                entityUpdated = (DocumentoPessoa)pessoaDocumentos.get(0);
            }
        }
        entityUpdated.getDoc().setDataAlteracao(LocalDate.now());
        entityUpdated.getDoc().setDataValidade(entity.getDoc().getDataValidade());
        if (Objects.nonNull(entity.getDoc().getArquivo()) && Objects.nonNull(entity.getDoc().getArquivo().getId())) {
            Arquivo arquivo = (Arquivo)this.arquivoService.findById((Serializable)entity.getDoc().getArquivo().getId()).get();
            entityUpdated.getDoc().setArquivo(arquivo);
        } else {
            entityUpdated.getDoc().setArquivo(null);
        }
        return (DocumentoPessoa)super.save((EloEntity)entityUpdated, authentication);
    }

    private Specification<DocumentoPessoa> docAlreadyExists(Long pessoa, Long documento, String numeroDocumento, LocalDate dataEmissao) {
        return (Specification & Serializable)(root, query, criteriaBuilder) -> criteriaBuilder.and(new Predicate[]{criteriaBuilder.equal((Expression)root.get("pessoa").get("id"), (Object)pessoa), criteriaBuilder.equal((Expression)root.get("doc").get("documento").get("id"), (Object)documento), criteriaBuilder.equal((Expression)root.get("doc").get("numeroDocumento"), (Object)numeroDocumento), criteriaBuilder.equal((Expression)root.get("doc").get("dataEmissao"), (Object)dataEmissao)});
    }
}

