/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.service;

import br.com.elotech.di.domain.Cidade;
import br.com.elotech.di.domain.dto.duplicacao.CidadeSimilaridadeDTO;
import br.com.elotech.di.domain.support.EloDomain;
import br.com.elotech.di.repository.Cidades;
import br.com.elotech.di.service.support.UnicoCrudService;
import java.util.Objects;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class CidadeService
extends UnicoCrudService<Cidade, Long> {
    public Cidades getRepository() {
        return (Cidades)super.getRepository();
    }

    public Page<CidadeSimilaridadeDTO> findAllWithSimilarity(Pageable pageable, String search, Double similarityDegree, Boolean somenteComVinculo) {
        return this.getRepository().findAllWithSimilarity(pageable, "%".concat(Optional.ofNullable(search).orElse("").concat("%")), similarityDegree, somenteComVinculo.toString());
    }

    public Optional<Cidade> findFirstByCodigoIbgeAndInativoFalse(Long codigoIbge) {
        return this.getRepository().findFirstByCodigoIbgeAndInativoFalse(codigoIbge);
    }

    public Optional<Cidade> findFirstByDescricaoIgnoreCaseAndInativoFalse(String descricao) {
        return this.getRepository().findFirstByDescricaoIgnoreCaseAndInativoFalse(descricao);
    }

    protected void beforeSave(Cidade entity, Authentication authentication) {
        if (Objects.isNull(entity.getInativo())) {
            entity.setInativo(Boolean.FALSE);
        }
        super.beforeSave((EloDomain)entity, authentication);
    }
}

