/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.service;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.di.domain.Pessoa;
import br.com.elotech.tributos.client.feign.CadastroAvulsoFeignClient;
import br.com.elotech.tributos.dto.CadastroGeralDTO;
import br.com.elotech.tributos.dto.StatusCadastroAvulsoByPessoaDTO;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class CadastroGeralService {
    @Autowired
    private final CadastroAvulsoFeignClient cadastroAvulsoFeignClient;

    public StatusCadastroAvulsoByPessoaDTO getStatusCadastroAvulsoByPessoa(Pessoa pessoa) {
        return this.getCadastroAvulsoFeignClient().statusCadastroAvulsoByPessoa(pessoa.getCnpjCpf());
    }

    public CadastroGeralDTO createNewCadastroAvulsoByPessoa(Pessoa pessoa) {
        return this.getCadastroAvulsoFeignClient().incluirCadastroAvulsoByPessoaCnpjCpf(pessoa.getCnpjCpf());
    }

    private CadastroAvulsoFeignClient getCadastroAvulsoFeignClient() {
        if (this.cadastroAvulsoFeignClient == null) {
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, "N\u00e3o foi poss\u00edvel completar requisi\u00e7\u00e3o com o oxy-tributos");
        }
        return this.cadastroAvulsoFeignClient;
    }

    @Generated
    public CadastroGeralService(CadastroAvulsoFeignClient cadastroAvulsoFeignClient) {
        this.cadastroAvulsoFeignClient = cadastroAvulsoFeignClient;
    }
}

