/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.service;

import br.com.elotech.core.service.support.CrudServiceException;
import br.com.elotech.di.domain.BancoPessoa;
import br.com.elotech.di.domain.EloEntityPessoaInverse;
import br.com.elotech.di.domain.Pessoa;
import br.com.elotech.di.repository.BancoPessoas;
import br.com.elotech.di.service.CrudServicePessoaInverse;
import br.com.elotech.di.service.PessoaService;
import br.com.elotech.di.validation.EloValidatorBancoPessoa;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class BancoPessoaService
extends CrudServicePessoaInverse<BancoPessoa, Long> {
    @Autowired
    private PessoaService pessoaService;
    @Autowired
    private BancoPessoas bancoPessoaRepository;
    @Autowired
    private EloValidatorBancoPessoa validator;

    protected void afterSave(BancoPessoa saved, Authentication authentication) {
        super.afterSave((EloEntityPessoaInverse)saved, authentication);
        Pessoa loadedPessoa = (Pessoa)this.pessoaService.findOne((Serializable)saved.getPessoa().getId());
        CrudServiceException.throwExceptionViolations((List)this.validator.valid(loadedPessoa));
    }

    public Boolean updateSetContaSalario(Boolean isContaSalario, Long contaBancariaId) {
        if (Objects.isNull(contaBancariaId)) {
            return Boolean.FALSE;
        }
        this.bancoPessoaRepository.updateSetContaSalario(isContaSalario, contaBancariaId);
        return Boolean.TRUE;
    }
}

