/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.json.update.JsonUpdatePartial;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.di.domain.Usuario;
import br.com.elotech.di.domain.shared.Arquivo;
import br.com.elotech.di.domain.shared.AssinaturaDigital;
import br.com.elotech.di.service.ArquivoServiceImpl;
import br.com.elotech.di.service.UsuarioLogadoService;
import br.com.elotech.di.service.UsuarioService;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.NotFoundException;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class AssinaturaDigitalService
extends CrudService<AssinaturaDigital, Long> {
    private final UsuarioService usuarioService;
    private final UsuarioLogadoService usuarioLogadoService;
    private final ArquivoServiceImpl arquivoService;

    protected void beforeSave(AssinaturaDigital entity, Authentication authentication) {
        Optional.ofNullable(entity.getArquivo()).ifPresent(a -> {
            Arquivo arquivo = (Arquivo)this.arquivoService.findOne((Serializable)a.getId());
            entity.setArquivo(arquivo);
        });
        super.beforeSave((EloEntity)entity, authentication);
    }

    protected void beforeInsert(AssinaturaDigital entity) {
        Usuario usuarioLogado = this.findUsuarioLogado();
        entity.setUsuarioCriacao(usuarioLogado);
        entity.setDataCriacao(LocalDate.now());
        super.beforeInsert((EloEntity)entity);
    }

    protected void beforeEdit(AssinaturaDigital entity) {
        AssinaturaDigital assinaturaDigital = (AssinaturaDigital)this.getRepository().findOne((Object)entity.getId());
        entity.setUsuarioCriacao(assinaturaDigital.getUsuarioCriacao());
        entity.setDataCriacao(assinaturaDigital.getDataCriacao());
        Usuario usuarioLogado = this.findUsuarioLogado();
        entity.setUsuarioAlteracao(usuarioLogado);
        entity.setDataAlteracao(LocalDate.now());
        super.beforeEdit((EloEntity)entity);
    }

    protected void beforeEditPartial(AssinaturaDigital entity, List<JsonUpdatePartial> updates) {
        AssinaturaDigital assinaturaDigital = (AssinaturaDigital)this.getRepository().findOne((Object)entity.getId());
        entity.setUsuarioCriacao(assinaturaDigital.getUsuarioCriacao());
        entity.setDataCriacao(assinaturaDigital.getDataCriacao());
        Usuario usuarioLogado = this.findUsuarioLogado();
        entity.setUsuarioAlteracao(usuarioLogado);
        entity.setDataAlteracao(LocalDate.now());
        super.beforeEditPartial((EloEntity)entity, updates);
    }

    public Page<AssinaturaDigital> findByRsql(String rsqlFilter, Pageable pageable) {
        StringBuilder filtro = new StringBuilder("usuarioCriacao.id == ").append(this.findUsuarioLogado().getId());
        if (!StringUtils.isBlank((String)rsqlFilter)) {
            filtro.append(';').append(rsqlFilter);
        }
        return super.findByRsql(filtro.toString(), pageable);
    }

    public AssinaturaDigital findOne(Long id) {
        AssinaturaDigital assinaturaDigital = (AssinaturaDigital)super.findOne((Serializable)id);
        Usuario usuarioLogado = this.findUsuarioLogado();
        if (assinaturaDigital.getUsuarioCriacao().equals((Object)usuarioLogado)) {
            return assinaturaDigital;
        }
        return null;
    }

    private Usuario findUsuarioLogado() {
        String username = this.usuarioLogadoService.getUsuarioLogado().getUsername();
        return Optional.ofNullable(this.usuarioService.findByUsuario(username)).orElseThrow(() -> new NotFoundException(String.format("Username %s", username)));
    }

    @Generated
    public AssinaturaDigitalService(UsuarioService usuarioService, UsuarioLogadoService usuarioLogadoService, ArquivoServiceImpl arquivoService) {
        this.usuarioService = usuarioService;
        this.usuarioLogadoService = usuarioLogadoService;
        this.arquivoService = arquivoService;
    }
}

