/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.service;

import br.com.elotech.arquivos.client.ArquivoClient;
import br.com.elotech.arquivos.domain.request.ArquivoDownloadRequest;
import br.com.elotech.arquivos.domain.request.ArquivoFindRequest;
import br.com.elotech.arquivos.domain.request.ArquivoNovoRequest;
import br.com.elotech.arquivos.domain.request.ArquivoUpdateRequest;
import br.com.elotech.arquivos.domain.request.ArquivoUploadRequest;
import br.com.elotech.arquivos.domain.response.ArquivoContent;
import br.com.elotech.arquivos.domain.response.ArquivoUrl;
import br.com.elotech.arquivos.domain.support.ContentDisposition;
import br.com.elotech.arquivos.domain.support.ContentType;
import br.com.elotech.arquivos.domain.support.Tenant;
import br.com.elotech.console.dto.Modulo;
import br.com.elotech.di.domain.HashArquivosCloudConfig;
import br.com.elotech.di.domain.shared.Arquivo;
import br.com.elotech.di.domain.shared.MetaDadoValor;
import br.com.elotech.di.domain.shared.TipoArquivo;
import br.com.elotech.di.domain.shared.TipoArquivoStorageEnum;
import br.com.elotech.di.repository.Arquivos;
import br.com.elotech.di.service.ArquivoService;
import br.com.elotech.di.service.EntidadeService;
import br.com.elotech.di.service.HashArquivosCloudConfigService;
import br.com.elotech.di.service.TipoArquivoService;
import br.com.elotech.unico.client.domain.TipoArquivoEnum;
import br.com.elotech.unico.client.dto.ArquivoDTO;
import br.com.elotech.unico.client.dto.EloArquivoContentDTO;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.Valid;
import javax.ws.rs.NotFoundException;
import lombok.Generated;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ArquivoStorageServiceImpl
implements ArquivoService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArquivoStorageServiceImpl.class);
    private final Arquivos arquivos;
    private final TipoArquivoService tipoArquivoService;
    private final ArquivoClient arquivoClient;
    private final EntidadeService entidadeService;
    private final HashArquivosCloudConfigService hashArquivosCloudConfig;
    private final Environment environment;

    public ArquivoDTO findOne(Long id) throws NotFoundException {
        Arquivo arquivo = (Arquivo)this.arquivos.findOne((Object)id);
        if (arquivo == null) {
            throw new NotFoundException(String.format("N\u00e3o foi poss\u00edvel buscar o arquivo %d", id));
        }
        return arquivo.toDTO();
    }

    public ArquivoDTO findOneWithContent(Long id) {
        Arquivo arquivo = (Arquivo)this.arquivos.findOne((Object)id);
        ArquivoContent arquivoContent = this.buscarArquivo(arquivo.getFullPath());
        ArquivoDTO dto = arquivo.toDTO();
        try {
            dto.setContent(EloArquivoContentDTO.builder().binary(arquivoContent.getContent().readAllBytes()).mimeType(arquivoContent.getContentType()).build());
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("N\u00e3o foi poss\u00edvel buscar o conte\u00fado do arquivo %d", id));
        }
        return dto;
    }

    public ArquivoContent buscarArquivo(String fullPath) {
        String[] fullPathArray = Optional.ofNullable(fullPath).orElse("").split("/");
        if (fullPathArray.length <= 1) {
            throw new IllegalArgumentException("N\u00e3o foi poss\u00edvel obter o tenant do arquivo selecionado.");
        }
        String tenant = fullPathArray[0];
        ArquivoFindRequest arquivoFindRequest = new ArquivoFindRequest(Tenant.create((String)tenant), fullPath);
        return (ArquivoContent)this.arquivoClient.buscarArquivo(arquivoFindRequest).orElseThrow(() -> new NotFoundException(String.format("N\u00e3o foi poss\u00edvel buscar o arquivo %s", fullPath)));
    }

    public ArquivoUrl getUrlUpload(Modulo modulo, String filePath, String fileName, ContentType contentType) {
        String tenantId = this.entidadeService.getTenantId();
        LOGGER.info("Iniciando a gera\u00e7\u00e3o de url para upload. Tenant: {}", (Object)tenantId);
        ArquivoUploadRequest uploadRequest = ArquivoUploadRequest.create((Tenant)Tenant.create((String)tenantId), (Modulo)modulo, (String)filePath, (String)fileName, (ContentType)contentType, null);
        LOGGER.info("Gera\u00e7\u00e3o de url para upload finalizada");
        return this.arquivoClient.gerarUrlParaUpload(uploadRequest);
    }

    public ArquivoUrl getUrlUploadUnico(TipoArquivoStorageEnum tipoArquivoStorage, String fileName, ContentType contentType) {
        return this.getUrlUpload(Modulo.OXY_UNICO, tipoArquivoStorage.getFilePath(), fileName, contentType);
    }

    public ArquivoUrl getUrlDownload(String fullPath, String fileName, ContentDisposition contentDisposition) {
        return this.getUrlDownload(fullPath, fileName, this.entidadeService.getTenantId(), contentDisposition);
    }

    public ArquivoUrl getUrlDownload(String fullPath, String fileName, String tenantId, ContentDisposition contentDisposition) {
        LOGGER.info("Iniciando a gera\u00e7\u00e3o de url para download");
        ArquivoDownloadRequest downloadRequest = ArquivoDownloadRequest.create((Tenant)Tenant.create((String)Optional.ofNullable(tenantId).orElseGet(() -> ((EntidadeService)this.entidadeService).getTenantId())), (String)fullPath, (Integer)604800, (ContentDisposition)contentDisposition, (String)fileName);
        LOGGER.info("Gera\u00e7\u00e3o de url para download finalizada");
        return this.arquivoClient.gerarUrlParaGet(downloadRequest);
    }

    public ArquivoDTO create(ArquivoDTO dto) {
        TipoArquivo tipo = this.tipoArquivoService.findByTipo(dto.getTipo());
        if (Strings.isBlank((String)dto.getMimeType()) && Strings.isNotBlank((String)dto.getNome())) {
            ContentType contentType = ContentType.fromExtension((String)dto.getNome());
            dto.setMimeType(contentType.getType());
        }
        Arquivo arquivo = Arquivo.ofDTO((ArquivoDTO)dto);
        arquivo.setTipo(tipo);
        return ((Arquivo)this.arquivos.save((Object)arquivo)).toDTO();
    }

    public ArquivoDTO createWithFile(@Valid ArquivoDTO dto, MultipartFile file) throws IOException {
        TipoArquivo tipo = this.tipoArquivoService.findByTipo(dto.getTipo());
        Arquivo arquivo = this.buildArquivo(dto, file, tipo);
        if (this.utilizaCloud().booleanValue()) {
            br.com.elotech.arquivos.domain.Arquivo arquivoStorage = this.uploadFileStorage(dto, file);
            arquivo.setDataCriacao(arquivoStorage.getDataCriacao().toLocalDate());
            arquivo.setFullPath(arquivoStorage.getFullPath());
            arquivo.setFullPathOriginal(arquivoStorage.getFullPath());
        }
        Arquivo arquivoSalvo = (Arquivo)this.arquivos.save((Object)arquivo);
        return arquivoSalvo.toDTO();
    }

    private Arquivo buildArquivo(ArquivoDTO dto, MultipartFile file, TipoArquivo tipo) {
        Arquivo arquivo = new Arquivo();
        arquivo.setNome(dto.getNome());
        arquivo.setUsuario(dto.getUsuario());
        arquivo.setTipo(tipo);
        arquivo.setModulo(dto.getModulo());
        arquivo.setMimeType(file.getContentType());
        String value = Optional.ofNullable(dto.getTipo()).map(TipoArquivoEnum::getValue).orElse(null);
        if (Arrays.stream(TipoArquivoEnum.values()).anyMatch(t -> t.getValue().equals(value)) && TipoArquivoEnum.fromValue((String)value).getMetadados().length > 0 && Objects.nonNull(dto.getMetadados())) {
            arquivo.setMetaDados(dto.getMetadados().entrySet().stream().map(e -> MetaDadoValor.of((String)((String)e.getKey()), (String)((String)e.getValue()))).collect(Collectors.toList()));
        }
        return arquivo;
    }

    private br.com.elotech.arquivos.domain.Arquivo uploadFileStorage(ArquivoDTO dto, MultipartFile file) throws IOException {
        LOGGER.info("Iniciando upload para o storage");
        br.com.elotech.arquivos.domain.Arquivo arquivo = this.createArquivo(file.getContentType(), file.getInputStream(), dto.getNome(), dto.getFilePath(), dto.getModulo());
        LOGGER.info("Finalizado upload para o storage");
        return arquivo;
    }

    public br.com.elotech.arquivos.domain.Arquivo createArquivo(String contentType, InputStream inputStream, String fileName, String filePath, Modulo modulo, String tenant) {
        ArquivoNovoRequest novo = ArquivoNovoRequest.builder((Tenant)Tenant.create((String)tenant), (Modulo)modulo).fileName(fileName).filePath(filePath).content(inputStream).contentType(ContentType.fromType((String)contentType)).build();
        return this.arquivoClient.criarArquivo(novo);
    }

    public br.com.elotech.arquivos.domain.Arquivo createArquivo(String contentType, InputStream inputStream, String fileName, String filePath, Modulo modulo) {
        return this.createArquivo(contentType, inputStream, fileName, filePath, modulo, this.entidadeService.getTenantId());
    }

    public br.com.elotech.arquivos.domain.Arquivo updateArquivo(String contentType, InputStream inputStream, String fileName, String filePath, String fileFullPath, Modulo modulo) {
        ArquivoUpdateRequest update = ArquivoUpdateRequest.builder((Tenant)Tenant.create((String)this.entidadeService.getTenantId()), (Modulo)modulo).fileName(fileName).filePath(filePath).content(inputStream).fileFullPath(fileFullPath).contentType(ContentType.fromType((String)contentType)).build();
        return this.arquivoClient.updateArquivo(update);
    }

    public ArquivoDTO update(Long id, ArquivoDTO dto) {
        Arquivo arquivo = (Arquivo)this.arquivos.findOne((Object)id);
        arquivo.setFullPath(dto.getFullPath());
        return ((Arquivo)this.arquivos.saveAndFlush((Object)arquivo)).toDTO();
    }

    public void delete(Long id) throws NotFoundException {
        LOGGER.info("Vai excluir arquivo {}.", (Object)id);
        Arquivo arquivo = (Arquivo)this.arquivos.findOne((Object)id);
        if (arquivo == null) {
            throw new NotFoundException(String.format("N\u00e3o foi encontrado um arquivo com o ID %d.", id));
        }
        LOGGER.info("Excluindo arquivo {}.", (Object)arquivo);
        this.arquivos.delete((Object)arquivo);
        LOGGER.info("Arquivo exclu\u00eddo");
    }

    public Boolean utilizaCloud() {
        if ("".equals(this.entidadeService.getTenantIdOrBlank())) {
            return false;
        }
        if (Stream.of(this.environment.getActiveProfiles()).anyMatch("cloud"::equalsIgnoreCase)) {
            return true;
        }
        HashArquivosCloudConfig configs = this.hashArquivosCloudConfig.getActualConfig();
        return configs != null && configs.getAtivado() != false;
    }

    public HashArquivosCloudConfig atualizaConfigCloud() {
        return this.hashArquivosCloudConfig.updateConfigsFromConsole(null, Boolean.valueOf(true));
    }

    @Generated
    public ArquivoStorageServiceImpl(Arquivos arquivos, TipoArquivoService tipoArquivoService, ArquivoClient arquivoClient, EntidadeService entidadeService, HashArquivosCloudConfigService hashArquivosCloudConfig, Environment environment) {
        this.arquivos = arquivos;
        this.tipoArquivoService = tipoArquivoService;
        this.arquivoClient = arquivoClient;
        this.entidadeService = entidadeService;
        this.hashArquivosCloudConfig = hashArquivosCloudConfig;
        this.environment = environment;
    }
}

