/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.service;

import br.com.elotech.arquivos.domain.support.ContentType;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.di.domain.shared.Arquivo;
import br.com.elotech.di.domain.shared.TipoArquivo;
import br.com.elotech.di.domain.shared.solicitacaoassinatura.SolicitacaoAssinaturaArquivo;
import br.com.elotech.di.repository.Arquivos;
import br.com.elotech.di.service.ArquivoService;
import br.com.elotech.unico.client.dto.EloArquivoContentDTO;
import br.com.elotech.utils.pdf.sign.PdfSigner;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import lombok.Generated;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class ArquivoServiceImpl
extends CrudService<Arquivo, Long>
implements ArquivoService {
    private final Arquivos arquivosRepositoy;

    public byte[] adicionarCodigoAutenticidade(Arquivo arquivo, byte[] content) {
        boolean isPdf = ContentType.APPLICATION_PDF.equals((Object)ContentType.fromExtension((String)FilenameUtils.getExtension((String)arquivo.getNome())));
        if (isPdf && Objects.isNull(arquivo.getCodigoAutenticidade())) {
            arquivo.setCodigoAutenticidade(this.gerarCodigoAutenticacao());
            content = new PdfSigner().adicionarCodigoAutenticacao(content, arquivo.getCodigoAutenticidade());
        }
        return content;
    }

    public void markAsSigned(Long idArquivo) {
        Arquivo arquivo = (Arquivo)this.getCrudRepository().findById((Object)idArquivo).orElseThrow();
        if (!arquivo.getFullPath().endsWith("_signed")) {
            arquivo.setFullPath(arquivo.getFullPath().concat("_signed"));
            this.getCrudRepository().saveAndFlush((Object)arquivo);
        }
    }

    public Page<Arquivo> findByRsqlAndNotInOtherSolicitacao(String search, Pageable pageable) {
        Specification specification = Specification.where(ArquivoServiceImpl::byArquivosNaoUsadosEmSolicitacoes);
        if (!StringUtils.isBlank((String)search)) {
            specification = specification.and(this.createSpecification(Optional.empty(), this.buildRsqlFilter(search)));
        }
        return this.findAll(specification, pageable);
    }

    public List<Arquivo> findArquivoPorTipoArquivoAndFinalidade(TipoArquivo tipoArquivo, String finalidade) {
        return this.arquivosRepositoy.findByTipoAndFinalidade(tipoArquivo, finalidade);
    }

    public EloArquivoContentDTO getFotoByPessoaId(Long pessoaId) {
        return this.arquivosRepositoy.getFotoByPessoaId(pessoaId);
    }

    private String gerarCodigoAutenticacao() {
        return UUID.randomUUID().toString().replace("-", "").toUpperCase();
    }

    protected static Predicate byArquivosNaoUsadosEmSolicitacoes(Root<Arquivo> rootArquivo, CriteriaQuery<?> query, CriteriaBuilder cb) {
        Subquery subQuery = query.subquery(Long.class);
        Root rootSAA = subQuery.from(SolicitacaoAssinaturaArquivo.class);
        subQuery.select((Expression)rootSAA.get("arquivo").get("id"));
        return cb.and(new Predicate[]{rootArquivo.get("id").in(new Expression[]{subQuery}).not()});
    }

    @Generated
    public ArquivoServiceImpl(Arquivos arquivosRepositoy) {
        this.arquivosRepositoy = arquivosRepositoy;
    }
}

