/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.service;

import br.com.elotech.arquivos.domain.support.ContentType;
import br.com.elotech.console.dto.Modulo;
import br.com.elotech.di.domain.dto.MigrarArquivoDTO;
import br.com.elotech.di.domain.shared.Arquivo;
import br.com.elotech.di.repository.Arquivos;
import br.com.elotech.di.service.ArquivoStorageServiceImpl;
import br.com.elotech.di.service.EntidadeService;
import br.com.elotech.di.service.UsuarioLogadoService;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.Optional;
import javax.transaction.Transactional;
import lombok.Generated;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@Transactional
public class ArquivoMigrationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ArquivoMigrationService.class);
    private final Arquivos repository;
    private final ArquivoStorageServiceImpl storage;
    private final UsuarioLogadoService usuarioLogadoService;
    private final EntidadeService entidadeService;

    public Arquivo migrarArquivo(MigrarArquivoDTO item) {
        Arquivo arquivo = (Arquivo)this.repository.getOne((Object)item.getArquivoId());
        String nome = Optional.ofNullable(arquivo.getNome()).orElse("");
        String contentType = this.getContentType(nome);
        String fileName = nome.trim().replaceAll("[^a-zA-Z.|\\d]", "_");
        String filePath = this.getFilePath();
        String tenant = this.getTenant();
        String newFullPath = arquivo.getFullPath();
        String newFullPathOriginal = arquivo.getFullPathOriginal();
        Modulo modulo = this.getModulo(arquivo);
        arquivo.setMigradoDateTimeStart(LocalDateTime.now());
        if (this.repository.hasContent(arquivo.getId()).booleanValue()) {
            try (ByteArrayInputStream contentAsStream = this.repository.getContentAsInputStream(arquivo.getId());){
                newFullPathOriginal = newFullPath = this.storage.createArquivo(contentType, (InputStream)contentAsStream, fileName, filePath, modulo, tenant).getFullPath();
            }
        } else {
            log.info("O arquivo {} n\u00e3o tem conte\u00fado na tabela content", (Object)item.getArquivoId());
        }
        this.setMetadadosArquivo(arquivo, newFullPath, newFullPathOriginal, modulo, contentType);
        return (Arquivo)this.repository.save((Object)arquivo);
    }

    private String getTenant() {
        return this.entidadeService.getTenantId();
    }

    private String getFilePath() {
        return "/arquivos-migrados";
    }

    protected String getContentType(String nome) {
        return ContentType.fromExtension((String)FilenameUtils.getExtension((String)nome)).getDescricao();
    }

    private Modulo getModulo(Arquivo arquivo) {
        return Optional.ofNullable(arquivo.getModulo()).orElse(Modulo.OXY_UNICO);
    }

    private void setMetadadosArquivo(Arquivo arquivo, String fullpath, String fullPathOriginal, Modulo modulo, String contentType) {
        arquivo.setMigradoDateTimeEnd(LocalDateTime.now());
        arquivo.setMigradoUsuario(this.usuarioLogadoService.getIdUsuarioLogado());
        arquivo.setFullPath(fullpath);
        arquivo.setFullPathOriginal(fullPathOriginal);
        arquivo.setModulo(modulo);
        arquivo.setMimeType(contentType);
        arquivo.setMigrado(Boolean.valueOf(true));
    }

    @Generated
    public ArquivoMigrationService(Arquivos repository, ArquivoStorageServiceImpl storage, UsuarioLogadoService usuarioLogadoService, EntidadeService entidadeService) {
        this.repository = repository;
        this.storage = storage;
        this.usuarioLogadoService = usuarioLogadoService;
        this.entidadeService = entidadeService;
    }
}

