/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.service;

import br.com.elotech.arquivos.domain.response.ArquivoUrl;
import br.com.elotech.arquivos.domain.support.ContentDisposition;
import br.com.elotech.di.domain.CertificadoDigital;
import br.com.elotech.di.domain.Cidade;
import br.com.elotech.di.domain.Entidade;
import br.com.elotech.di.domain.UF;
import br.com.elotech.di.domain.dto.assinatura.AssinaturaCarimboDTO;
import br.com.elotech.di.domain.dto.assinatura.AssinaturaTextoDTO;
import br.com.elotech.di.domain.shared.Arquivo;
import br.com.elotech.di.domain.shared.ArquivoContent;
import br.com.elotech.di.domain.shared.AssinaturaDigital;
import br.com.elotech.di.domain.shared.TipoAssinatura;
import br.com.elotech.di.repository.Arquivos;
import br.com.elotech.di.service.ArquivoStorageServiceImpl;
import br.com.elotech.di.service.AssinaturaDigitalService;
import br.com.elotech.di.service.EntidadeService;
import br.com.elotech.di.utils.ArquivoAssinaturaUtils;
import br.com.elotech.utils.pdf.sign.PdfSigner;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateExpiredException;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.springframework.stereotype.Service;

@Service
public class ArquivoAssinaturaCarimboService {
    private final Arquivos arquivos;
    private final ArquivoStorageServiceImpl arquivoStorageService;
    private final AssinaturaDigitalService assinaturaDigitalService;
    private final ArquivoAssinaturaUtils arquivoAssinaturaUtils;
    private final EntidadeService entidadeService;

    public void assinarComCarimbo(AssinaturaCarimboDTO dto) {
        AssinaturaDigital assinaturaDigital = this.getAssinaturaDigitalTipoCarimbo(dto.getIdCarimbo());
        Arquivo arquivoEntity = (Arquivo)this.arquivos.getOne((Object)dto.getIdArquivo());
        ArquivoUrl arquivoUrl = this.arquivoStorageService.getUrlDownload(arquivoEntity.getFullPath(), arquivoEntity.getNome(), ContentDisposition.ATTACHMENT);
        this.assinarDocumentoComCarimbo(dto.getPage(), arquivoEntity, arquivoUrl, assinaturaDigital.getArquivo().getContent().getBinary(), assinaturaDigital.getArquivo().getNome(), Float.valueOf(dto.getPosX().floatValue()), Float.valueOf(dto.getPosY().floatValue()));
    }

    public void assinarComTexto(AssinaturaTextoDTO dto) {
        Arquivo arquivoEntity = (Arquivo)this.arquivos.getOne((Object)dto.getIdArquivo());
        ArquivoUrl arquivoUrl = this.arquivoStorageService.getUrlDownload(arquivoEntity.getFullPath(), arquivoEntity.getNome(), ContentDisposition.ATTACHMENT);
        this.assinarDocumentoComTexto(arquivoEntity, arquivoUrl, dto.getTexto(), Float.valueOf(dto.getPosX().floatValue()), Float.valueOf(dto.getPosY().floatValue()), dto.getPage());
    }

    protected AssinaturaDigital getAssinaturaDigitalTipoCarimbo(Long idCarimbo) {
        AssinaturaDigital assinaturaDigital = this.assinaturaDigitalService.findOne(idCarimbo);
        if (!assinaturaDigital.getTipoAssinatura().equals((Object)TipoAssinatura.ASSINATURA_ELETRONICA)) {
            throw new IllegalArgumentException("A assinatura selecionada n\u00e3o \u00e9 do tipo Carimbo");
        }
        if (Objects.isNull(Optional.ofNullable(Optional.ofNullable(assinaturaDigital.getArquivo()).orElse(new Arquivo()).getContent()).orElse(new ArquivoContent()).getBinary())) {
            throw new IllegalArgumentException("N\u00e3o foi poss\u00edvel obter o carimbo");
        }
        return assinaturaDigital;
    }

    protected void assinarDocumentoComCarimbo(Integer page, Arquivo arquivoEntity, ArquivoUrl arquivoUrl, byte[] carimbo, String arquivoNome, Float posX, Float posY) throws IOException, CertificateExpiredException {
        Entidade entidade = this.entidadeService.getObjetoEntidadeLogada();
        this.validaCertificadoEntidade(entidade);
        CertificadoDigital certificadoDigital = CertificadoDigital.builder().usuario(arquivoEntity.getUsuario().toString()).password(entidade.getCertificado().getSenha()).arquivo(new ByteArrayInputStream(entidade.getCertificado().getArquivo().getContent().getBinary())).alias(entidade.getCertificado().getNome()).build();
        Cidade cidade = Optional.ofNullable(entidade.getCidade()).orElse(new Cidade());
        UF uf = Optional.ofNullable(cidade.getUf()).orElse(new UF());
        PdfSigner pdfSign = new PdfSigner(certificadoDigital.getArquivo(), certificadoDigital.getPassword(), certificadoDigital.getAlias(), certificadoDigital.getUsuario(), entidade.getNome(), uf.getDescricao());
        pdfSign.setImage(carimbo);
        pdfSign.setImageName(arquivoNome);
        pdfSign.setShowImage(Boolean.valueOf(true));
        byte[] pdfOutput = pdfSign.signPdf(IOUtils.toByteArray((InputStream)this.arquivoStorageService.buscarArquivo(arquivoUrl.getFullPath()).getContent()), posX, posY, page);
        this.arquivoAssinaturaUtils.createOrUpdateFile(arquivoEntity, pdfOutput);
    }

    protected void validaCertificadoEntidade(Entidade entidade) {
        if (Objects.isNull(entidade.getCertificado())) {
            throw new IllegalArgumentException(String.format("Certificado padr\u00e3o n\u00e3o encontrado para a entidade %s", entidade.getNome()));
        }
    }

    protected void assinarDocumentoComTexto(Arquivo arquivoEntity, ArquivoUrl arquivoUrl, String text, Float posX, Float posY, Integer pageNum) throws IOException, CertificateExpiredException {
        Entidade entidade = this.entidadeService.getObjetoEntidadeLogada();
        this.validaCertificadoEntidade(entidade);
        CertificadoDigital certificadoDigital = CertificadoDigital.builder().usuario(arquivoEntity.getUsuario().toString()).password(entidade.getCertificado().getSenha()).arquivo(new ByteArrayInputStream(entidade.getCertificado().getArquivo().getContent().getBinary())).alias(entidade.getCertificado().getNome()).build();
        Cidade cidade = Optional.ofNullable(entidade.getCidade()).orElse(new Cidade());
        UF uf = Optional.ofNullable(cidade.getUf()).orElse(new UF());
        PdfSigner pdfSign = new PdfSigner(certificadoDigital.getArquivo(), certificadoDigital.getPassword(), certificadoDigital.getAlias(), certificadoDigital.getUsuario(), entidade.getNome(), uf.getDescricao());
        pdfSign.setShowText(Boolean.valueOf(true));
        pdfSign.setSignatureText(text);
        byte[] pdfOutput = pdfSign.signPdf(IOUtils.toByteArray((InputStream)this.arquivoStorageService.buscarArquivo(arquivoUrl.getFullPath()).getContent()), posX, posY, pageNum);
        this.arquivoAssinaturaUtils.createOrUpdateFile(arquivoEntity, pdfOutput);
    }

    @Generated
    public ArquivoAssinaturaCarimboService(Arquivos arquivos, ArquivoStorageServiceImpl arquivoStorageService, AssinaturaDigitalService assinaturaDigitalService, ArquivoAssinaturaUtils arquivoAssinaturaUtils, EntidadeService entidadeService) {
        this.arquivos = arquivos;
        this.arquivoStorageService = arquivoStorageService;
        this.assinaturaDigitalService = assinaturaDigitalService;
        this.arquivoAssinaturaUtils = arquivoAssinaturaUtils;
        this.entidadeService = entidadeService;
    }
}

