/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.service;

import br.com.elotech.arquivos.domain.response.ArquivoUrl;
import br.com.elotech.arquivos.domain.support.ContentDisposition;
import br.com.elotech.di.domain.CertificadoDigital;
import br.com.elotech.di.domain.Cidade;
import br.com.elotech.di.domain.Entidade;
import br.com.elotech.di.domain.UF;
import br.com.elotech.di.domain.dto.assinatura.AssinaturaCertificadoA1DTO;
import br.com.elotech.di.domain.shared.Arquivo;
import br.com.elotech.di.domain.shared.AssinaturaDigital;
import br.com.elotech.di.repository.Arquivos;
import br.com.elotech.di.service.ArquivoStorageServiceImpl;
import br.com.elotech.di.service.AssinaturaDigitalService;
import br.com.elotech.di.service.EntidadeService;
import br.com.elotech.di.utils.ArquivoAssinaturaUtils;
import br.com.elotech.utils.pdf.sign.PdfSigner;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.springframework.stereotype.Service;

@Service
public class ArquivoAssinaturaA1Service {
    private final Arquivos arquivos;
    private final ArquivoStorageServiceImpl arquivoStorageService;
    private final AssinaturaDigitalService assinaturaDigitalService;
    private final ArquivoAssinaturaUtils arquivoAssinaturaUtils;
    private final EntidadeService entidadeService;

    public void assinar(AssinaturaCertificadoA1DTO dto) throws IOException {
        Arquivo arquivo = (Arquivo)this.arquivos.getOne((Object)dto.getIdArquivo());
        UUID usuario = arquivo.getUsuario();
        Optional.ofNullable(usuario).orElseThrow(() -> new IllegalArgumentException(String.format("N\u00e3o foi encontrado o usu\u00e1rio para o Arquivo %s-%s", arquivo.getId(), arquivo.getNome())));
        ArquivoUrl arquivoUrl = this.arquivoStorageService.getUrlDownload(arquivo.getFullPath(), arquivo.getNome(), ContentDisposition.ATTACHMENT);
        AssinaturaDigital assinaturaDigital = this.assinaturaDigitalService.findOne(dto.getIdAssinatura());
        CertificadoDigital certificadoDigital = CertificadoDigital.builder().usuario(usuario.toString()).password(assinaturaDigital.getSenha()).arquivo(new ByteArrayInputStream(assinaturaDigital.getArquivo().getContent().getBinary())).alias(assinaturaDigital.getNome()).build();
        byte[] pdfAssinado = this.assinarPDF(this.loadFileFromURL(arquivoUrl), certificadoDigital);
        this.arquivoAssinaturaUtils.createOrUpdateFile(arquivo, pdfAssinado);
    }

    protected byte[] loadFileFromURL(ArquivoUrl arquivoUrl) throws IOException {
        return IOUtils.toByteArray((InputStream)new URL(arquivoUrl.getUrlAssinada()).openStream());
    }

    protected byte[] assinarPDF(byte[] pdf, CertificadoDigital certificadoDigital) {
        this.validCertificado(certificadoDigital);
        Entidade entidade = this.entidadeService.getObjetoEntidadeLogada();
        Cidade cidade = Optional.ofNullable(entidade.getCidade()).orElse(new Cidade());
        UF uf = Optional.ofNullable(cidade.getUf()).orElse(new UF());
        PdfSigner pdfSign = new PdfSigner(certificadoDigital.getArquivo(), certificadoDigital.getPassword(), certificadoDigital.getAlias(), certificadoDigital.getUsuario(), entidade.getNome(), uf.getDescricao());
        return pdfSign.signPdf(pdf);
    }

    protected void validCertificado(CertificadoDigital certificadoDigital) {
        if (!certificadoDigital.isValid().booleanValue()) {
            throw new IllegalArgumentException("Para assinar com certificado digital \u00e9 necess\u00e1rio informar o local do certificado, o alias e a senha.");
        }
    }

    @Generated
    public ArquivoAssinaturaA1Service(Arquivos arquivos, ArquivoStorageServiceImpl arquivoStorageService, AssinaturaDigitalService assinaturaDigitalService, ArquivoAssinaturaUtils arquivoAssinaturaUtils, EntidadeService entidadeService) {
        this.arquivos = arquivos;
        this.arquivoStorageService = arquivoStorageService;
        this.assinaturaDigitalService = assinaturaDigitalService;
        this.arquivoAssinaturaUtils = arquivoAssinaturaUtils;
        this.entidadeService = entidadeService;
    }
}

