/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.service;

import br.com.elotech.agendamento.client.AgendamentoFeignClient;
import br.com.elotech.agendamento.client.dto.AgendamentoDTO;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.di.domain.AgendadorArquivo;
import br.com.elotech.di.repository.AgendadorArquivoRepository;
import br.com.elotech.di.service.AgendadorArquivoService;
import br.com.elotech.di.utils.AmbienteUtils;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.http.HttpMethod;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class AgendadorArquivoService
extends CrudService<AgendadorArquivo, UUID> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AgendadorArquivoService.class);
    private final Optional<AgendamentoFeignClient> agendamentoFeignClient;
    private final ConfigurableEnvironment configurableEnvironment;
    private final AgendadorArquivoRepository agendadorArquivoRepository;

    public AgendadorArquivo save(AgendadorArquivo entity, Authentication authentication) {
        List existeAgendador = this.agendadorArquivoRepository.findAll();
        Optional<AgendadorArquivo> agendadorIgual = existeAgendador.stream().filter(agendador -> agendador.getHorario().equals(entity.getHorario()) && agendador.getPeriodicidade().equals((Object)entity.getPeriodicidade()) && agendador.getCodModeloArquivo().equals(entity.getCodModeloArquivo()) && !agendador.getId().equals(entity.getId())).findFirst();
        if (agendadorIgual.isPresent()) {
            throw new IllegalArgumentException("J\u00e1 existe um agendador nessas configura\u00e7\u00f5es");
        }
        AgendadorArquivo saved = (AgendadorArquivo)super.save((EloEntity)entity, authentication);
        if (Boolean.FALSE.equals(saved.getAtivo())) {
            this.verificarSeExisteAgendamentoEDeletar(saved);
        } else {
            this.createAgendamento(saved);
        }
        return saved;
    }

    public void verificarSeExisteAgendamentoEDeletar(AgendadorArquivo entity) {
        String jobRunrEntityId = this.buildAgendamentoId(entity);
        log.info("Consultando se existe agendamento para o agendamento: [{}], jobRunr: [{}]", (Object)entity.getId(), (Object)jobRunrEntityId);
        Optional existeAgendamento = ((AgendamentoFeignClient)this.agendamentoFeignClient.get()).find(TenantContextHolder.getCurrentTenantId(), jobRunrEntityId);
        if (existeAgendamento.isPresent()) {
            log.info("Excluindo agendamento: [{}], jobRunr: [{}]", (Object)entity.getId(), (Object)jobRunrEntityId);
            ((AgendamentoFeignClient)this.agendamentoFeignClient.get()).deleteById(TenantContextHolder.getCurrentTenantId(), jobRunrEntityId);
        }
    }

    public void createAgendamento(AgendadorArquivo entity) {
        AgendamentoDTO agendamentoDTO = new AgendamentoDTO();
        agendamentoDTO.setTenant(TenantContextHolder.getCurrentTenantId());
        agendamentoDTO.setHttpMethod(HttpMethod.POST);
        agendamentoDTO.setUrl(String.format("%s/api/modelos-arquivo/execute/execute-script-agendamento/%s", AmbienteUtils.getCurrentURLReportExecutor((ConfigurableEnvironment)this.configurableEnvironment), entity.getId()));
        agendamentoDTO.setId(this.buildAgendamentoId(entity));
        String[] horario = entity.getHorario().split(":");
        String mesDiaDaSemana = "* * *";
        switch (1.$SwitchMap$br$com$elotech$unico$client$domain$enums$TipoPeriodicidade[entity.getPeriodicidade().ordinal()]) {
            case 1: {
                mesDiaDaSemana = "* * 0";
                break;
            }
            case 2: {
                mesDiaDaSemana = "1 * *";
                break;
            }
            default: {
                mesDiaDaSemana = "* * *";
            }
        }
        agendamentoDTO.setCron(String.format("%s %s %s", horario[1], horario[0], mesDiaDaSemana));
        log.info("Criando agendamento...");
        String response = ((AgendamentoFeignClient)this.agendamentoFeignClient.get()).create(agendamentoDTO);
        log.info("Agendamento criado. Response: [{}]", (Object)response);
    }

    private String buildAgendamentoId(AgendadorArquivo agendador) {
        UUID id = agendador.getId();
        String nomeArquivo = agendador.getNomeModeloArquivo().replaceAll("[^a-zA-Z0-9]", "");
        return String.format("AgendadorArquivo-%s-%s", nomeArquivo, id);
    }

    @Generated
    public AgendadorArquivoService(Optional<AgendamentoFeignClient> agendamentoFeignClient, ConfigurableEnvironment configurableEnvironment, AgendadorArquivoRepository agendadorArquivoRepository) {
        this.agendamentoFeignClient = agendamentoFeignClient;
        this.configurableEnvironment = configurableEnvironment;
        this.agendadorArquivoRepository = agendadorArquivoRepository;
    }
}

