/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.security;

import br.com.elotech.core.config.DBConfigProperties;
import br.com.elotech.core.el.ELParser;
import br.com.elotech.core.security.UserDetailsLoader;
import br.com.elotech.di.config.UnicoProperties;
import br.com.elotech.di.security.CustomUserDetails;
import br.com.elotech.di.security.UserAuthority;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.jdbc.JdbcDaoImpl;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"!cloud"})
public class UnicoUserDetailsService
extends JdbcDaoImpl
implements UserDetailsService,
UserDetailsLoader,
InitializingBean {
    public static final String UPDATE_USER_BY_USERNAME = "update #{unico.schema}.usuario set senhaexpirada = 'S' where lower(usuario) = ? ";
    public static final String AUTHORITIES_BY_USERNAME_QUERY = "select lower(a.usuario) as username, b.nome as authority from #{unico.schema}.usuario a join #{unico.schema}.usuariorecurso c    on c.usuario = a.id   join #{unico.schema}.recurso b    on c.recurso = b.id where lower(a.usuario) = ?";
    public static final String GROUP_AUTHORITIES_BY_USERNAME_QUERY = "select distinct a.id, c.nome, e.nome   from #{unico.schema}.usuario a  inner join #{unico.schema}.usuariogrupo b on b.usuario = a.id  inner join #{unico.schema}.grupo c on c.id = b.grupo  inner join #{unico.schema}.gruporecurso d on d.grupo = c.id  inner join #{unico.schema}.recurso e on ( e.id = d.recurso or b.grupo=2) where lower(a.usuario) = ? ";
    private final ELParser elParser;
    private final DBConfigProperties properties;
    private final UnicoProperties unicoProperties;
    private final String updateUserSql;

    @Autowired
    public UnicoUserDetailsService(JdbcTemplate jdbcTemplate, ELParser elParser, DBConfigProperties properties, UnicoProperties unicoProperties) {
        this.elParser = elParser;
        this.properties = properties;
        this.setJdbcTemplate(jdbcTemplate);
        this.updateUserSql = elParser.evaluate(UPDATE_USER_BY_USERNAME, (Object)properties);
        this.setAuthoritiesByUsernameQuery(elParser.evaluate(AUTHORITIES_BY_USERNAME_QUERY, (Object)properties));
        this.setGroupAuthoritiesByUsernameQuery(elParser.evaluate(GROUP_AUTHORITIES_BY_USERNAME_QUERY, (Object)properties));
        this.setEnableGroups(true);
        this.unicoProperties = unicoProperties;
    }

    protected List<UserDetails> loadUsersByUsername(String username) {
        return this.getJdbcTemplate().query(this.elParser.evaluate(this.getUserByNameSqlQuery(), (Object)this.properties), (Object[])new String[]{username}, (RowMapper)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected UserDetails createUserDetails(String username, UserDetails userFromUserQuery, List<GrantedAuthority> combinedAuthorities) {
        CustomUserDetails customUserDetails = (CustomUserDetails)userFromUserQuery;
        ArrayList<UserAuthority> authorities = new ArrayList<UserAuthority>();
        for (GrantedAuthority grantedAuthority : combinedAuthorities) {
            authorities.add(new UserAuthority(grantedAuthority.getAuthority()));
        }
        return new CustomUserDetails(userFromUserQuery.getUsername(), userFromUserQuery.getPassword(), customUserDetails.getUserId(), userFromUserQuery.isEnabled(), userFromUserQuery.isAccountNonExpired(), userFromUserQuery.isCredentialsNonExpired(), userFromUserQuery.isAccountNonLocked(), customUserDetails.getModoAutenticacao(), authorities);
    }

    private String getUserByNameSqlQuery() {
        StringBuilder sql = new StringBuilder("SELECT a.id,\n").append("lower(a.usuario) as usuario,\n");
        if (this.unicoProperties.getCloud().booleanValue()) {
            sql.append(" a.senha, \n");
        } else {
            sql.append(" coalesce(a.senha,b.senha) as senha,\n");
        }
        sql.append("       a.ativo,\n").append("       a.email,\n").append("       a.contabloqueada,\n").append("       a.senhaexpirada,\n").append("       a.modoautenticacao,\n").append("       a.dataExpiracao\n").append(" FROM #{unico.schema}.usuario a\n");
        if (!this.unicoProperties.getCloud().booleanValue()) {
            sql.append(" left outer join #{aise.schema}.usuario b\n").append("    on b.idunico = a.id\n");
        }
        sql.append(" WHERE lower(a.usuario) = ?\n").append(" AND  (a.invalido = 'N' OR a.invalido IS NULL)\n");
        return sql.toString();
    }
}

