/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.security;

import br.com.elotech.core.security.Http401UnauthorizedEntryPoint;
import br.com.elotech.core.security.SecurityConfigurationOverride;
import br.com.elotech.core.security.authorization.AuthorizationInterApiProvider;
import br.com.elotech.core.security.jwt.TokenProvider;
import br.com.elotech.core.security.jwt.filter.SecurityFiltersConfigurer;
import br.com.elotech.di.security.LdapConfigurationProperties;
import br.com.elotech.di.security.UnicoAuthenticationProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpMethod;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ChannelSecurityConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.data.repository.query.SecurityEvaluationContextExtension;
import org.springframework.security.ldap.server.UnboundIdContainer;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.web.filter.CorsFilter;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(securedEnabled=true, prePostEnabled=true, jsr250Enabled=true)
@Order(value=1)
@Profile(value={"!cloud"})
public class UnicoSecurityConfiguration
extends WebSecurityConfigurerAdapter
implements SecurityConfigurationOverride {
    private static final String ROLE_CADASTRO_USUARIO = "FrmUnicoUsuario";
    @Autowired
    private Http401UnauthorizedEntryPoint authenticationEntryPoint;
    @Value(value="${security.require_ssl:false}")
    private Boolean requireSsl;
    @Value(value="${elotech.toggle.permission}")
    private Boolean enablePermission;
    @Autowired
    private LdapContextSource contextSource;
    @Autowired
    private LdapConfigurationProperties ldapProperties;
    @Autowired
    private TokenProvider tokenProvider;
    @Autowired
    private AuthorizationInterApiProvider authorizationInterApiProvider;
    @Autowired
    private CorsFilter corsFilter;
    @Autowired
    private UnicoAuthenticationProvider unicoAuthenticationProvider;

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder auth, ApplicationContext applicationContext) {
        auth.authenticationProvider((AuthenticationProvider)this.unicoAuthenticationProvider);
        if (this.ldapProperties.getEnabled().booleanValue()) {
            auth.ldapAuthentication().userSearchFilter("(&(objectClass=" + this.ldapProperties.getSearchFilter() + ")(" + this.ldapProperties.getFields().getUsuario() + "={0}))").contextSource((BaseLdapPathContextSource)this.contextSource);
        }
        if (this.ldapProperties.getLdif().getEnabled().booleanValue()) {
            UnboundIdContainer container = new UnboundIdContainer(this.ldapProperties.getBase(), this.ldapProperties.getLdif().getFile());
            container.setApplicationContext(applicationContext);
            container.setPort(this.ldapProperties.getPort());
            container.afterPropertiesSet();
        }
    }

    public void configure(WebSecurity web) {
        ((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)web.ignoring().antMatchers(HttpMethod.OPTIONS, new String[]{"/**"})).antMatchers(new String[]{"/unico/**/*.{js,html,css}"})).antMatchers(new String[]{"/*.{js,html,css}"})).antMatchers(new String[]{"/assets/**"})).antMatchers(new String[]{"/css/**"})).antMatchers(new String[]{"/fonts/**"})).antMatchers(new String[]{"/font-awesome/**"})).antMatchers(new String[]{"/img/**"})).antMatchers(new String[]{"/images/**"})).antMatchers(new String[]{"/js/**"})).antMatchers(new String[]{"/login/**/area.json"})).antMatchers(new String[]{"/batch.html"})).antMatchers(new String[]{"/h2-console/**"})).antMatchers(new String[]{"/rest/app/params"})).antMatchers(new String[]{"/actuator/**"})).antMatchers(new String[]{"/partials/**"});
    }

    protected void configure(HttpSecurity http) {
        if (this.requireSsl.booleanValue()) {
            ((ChannelSecurityConfigurer.RequiresChannelUrl)http.requiresChannel().anyRequest()).requiresSecure().and();
        }
        ((HttpSecurity)((HttpSecurity)http.exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)this.authenticationEntryPoint).and()).csrf().disable()).formLogin().disable();
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry authorizeRequests = http.authorizeRequests();
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)authorizeRequests.antMatchers(new String[]{"/"})).permitAll().antMatchers(new String[]{"/info"})).permitAll().antMatchers(new String[]{"/rest/login"})).permitAll().antMatchers(new String[]{"/api/authenticate"})).permitAll().antMatchers(new String[]{"/rest/token-acesso"})).permitAll().antMatchers(new String[]{"/rest/**/model"})).permitAll().antMatchers(new String[]{"/rest/**/model/**"})).permitAll().antMatchers(new String[]{"/rest/arquivos/**"})).permitAll().antMatchers(new String[]{"/rest/entidades/tenantId"})).permitAll().antMatchers(new String[]{"/rest/entidades/principal/**"})).permitAll().antMatchers(new String[]{"/rest/jobinfo"})).permitAll().antMatchers(new String[]{"/rest/jobinfo/**"})).permitAll().antMatchers(new String[]{"/jobinfo-updates"})).permitAll().antMatchers(new String[]{"/rest/modulos/**"})).permitAll().antMatchers(new String[]{"/rest/usuarios/emailMaskByUsuario/**"})).permitAll().antMatchers(new String[]{"/rest/usuarios/esqueciMinhaSenha/**"})).permitAll().antMatchers(new String[]{"/rest/usuarios/changePasswordByUserName/**"})).permitAll().antMatchers(HttpMethod.POST, new String[]{"/rest/usuarios"})).hasRole(ROLE_CADASTRO_USUARIO).antMatchers(HttpMethod.PUT, new String[]{"/rest/usuarios/**"})).hasRole(ROLE_CADASTRO_USUARIO).antMatchers(HttpMethod.DELETE, new String[]{"/rest/usuarios/**"})).hasRole(ROLE_CADASTRO_USUARIO).antMatchers(HttpMethod.GET, new String[]{"/rest/usuarios/me"})).authenticated().antMatchers(HttpMethod.GET, new String[]{"/rest/usuarios/changePassword"})).authenticated().antMatchers(HttpMethod.GET, new String[]{"/rest/usuarios/modulos"})).authenticated().antMatchers(HttpMethod.GET, new String[]{"/rest/usuarios/usernameByModulo/**"})).authenticated().antMatchers(HttpMethod.GET, new String[]{"/rest/usuarios/entidades-by-usuario"})).authenticated();
        if (this.enablePermission.booleanValue()) {
            this.addPermissions(authorizeRequests);
        }
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)authorizeRequests.anyRequest()).authenticated().and()).apply((SecurityConfigurerAdapter)this.securityConfigurerAdapter());
    }

    public void addPermissions(ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry authorizeRequests) {
        this.crudPermission(authorizeRequests, "/rest/agencias/**", "AGENCIA");
        this.crudPermission(authorizeRequests, "/rest/bairros/**", "BAIRRO");
        this.crudPermission(authorizeRequests, "/rest/logradouros/**", "LOGRADOURO");
        this.crudPermission(authorizeRequests, "/rest/bancos/**", "BANCO");
        this.crudPermission(authorizeRequests, "/rest/cidades/**", "CIDADE");
        this.crudPermission(authorizeRequests, "/rest/paises/**", "PAIS");
        this.crudPermission(authorizeRequests, "/rest/pessoas/**", "PESSOA");
        this.crudPermission(authorizeRequests, "/rest/ufs/**", "UF");
        this.crudPermission(authorizeRequests, "/rest/modulos/**", "MODULO");
        this.crudPermission(authorizeRequests, "/rest/grupos/**", "GRUPO");
        this.crudPermission(authorizeRequests, "/rest/recursos/**", "RECURSO");
    }

    public void crudPermission(ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry authorizeRequests, String route, String name) {
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)authorizeRequests.antMatchers(HttpMethod.POST, new String[]{route})).hasAuthority(name + "_CREATE").antMatchers(HttpMethod.GET, new String[]{route})).hasAuthority(name + "_READ").antMatchers(HttpMethod.PUT, new String[]{route})).hasAuthority(name + "_UPDATE").antMatchers(HttpMethod.PATCH, new String[]{route})).hasAuthority(name + "_UPDATE").antMatchers(HttpMethod.DELETE, new String[]{route})).hasAuthority(name + "_DELETE");
    }

    private SecurityFiltersConfigurer securityConfigurerAdapter() {
        return new SecurityFiltersConfigurer(this.tokenProvider, this.corsFilter, this.authorizationInterApiProvider);
    }

    @Bean
    public SecurityEvaluationContextExtension securityEvaluationContextExtension() {
        return new SecurityEvaluationContextExtension();
    }

    @Bean(name={"authenticationManager"})
    public AuthenticationManager authenticationManagerBean() throws Exception {
        return super.authenticationManagerBean();
    }
}

