/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.security;

import br.com.elotech.di.security.LdapConfigurationProperties;
import br.com.elotech.di.security.NonVerifyingSSLSocketFactory;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.LdapContextSource;

@Configuration
@ConditionalOnProperty(name={"ldap.enabled"}, havingValue="true", matchIfMissing=false)
public class LdapConfiguration {
    @Autowired
    private LdapConfigurationProperties properties;

    @Bean
    public LdapContextSource contextSource() {
        LdapContextSource contextSource = new LdapContextSource();
        contextSource.setUrls(this.properties.getUrl());
        contextSource.setBase(this.properties.getBase());
        contextSource.setUserDn(this.properties.getUserDn());
        contextSource.setPassword(this.properties.getPassword());
        contextSource.setPooled(false);
        if (this.properties.getDisableSslVerification().booleanValue()) {
            Map<String, String> baseEnv = Map.of("java.naming.ldap.factory.socket", NonVerifyingSSLSocketFactory.class.getName());
            contextSource.setBaseEnvironmentProperties(baseEnv);
        }
        return contextSource;
    }

    @Bean
    public LdapTemplate ldapTemplate() {
        return new LdapTemplate((ContextSource)this.contextSource());
    }
}

