/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.security;

import br.com.elotech.di.domain.UsuarioModoAutenticacao;
import br.com.elotech.di.security.UserAuthority;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.CredentialsContainer;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.Assert;

/*
 * Exception performing whole class analysis ignored.
 */
public class CustomUserDetails
implements UserDetails,
CredentialsContainer,
Authentication {
    private String username;
    private String password;
    @JsonIgnore
    private Set<UserAuthority> authorities;
    private boolean accountNonExpired;
    private boolean accountNonLocked;
    private boolean credentialsNonExpired;
    private boolean enabled;
    private long expires;
    private long userId;
    private UsuarioModoAutenticacao modoAutenticacao;

    public CustomUserDetails() {
    }

    public CustomUserDetails(String username, String password, long id, boolean enabled, boolean accountNonExpired, boolean credentialsNonExpired, boolean accountNonLocked, UsuarioModoAutenticacao modoAutenticacao, Collection<UserAuthority> authorities) {
        if (StringUtils.isBlank((String)username) || modoAutenticacao == UsuarioModoAutenticacao.INTERNO && password == null) {
            throw new IllegalArgumentException("Usu\u00e1rio e/ou senha n\u00e3o pode ser nulo.");
        }
        this.userId = id;
        this.username = username;
        this.password = password;
        this.enabled = enabled;
        this.accountNonExpired = accountNonExpired;
        this.credentialsNonExpired = credentialsNonExpired;
        this.accountNonLocked = accountNonLocked;
        this.modoAutenticacao = modoAutenticacao;
        this.authorities = Collections.unmodifiableSet(CustomUserDetails.sortAuthorities(authorities));
    }

    private static Set<UserAuthority> sortAuthorities(Collection<UserAuthority> authorities) {
        Assert.notNull(authorities, (String)"Cannot pass a null GrantedAuthority collection");
        LinkedHashSet<UserAuthority> sortedAuthorities = new LinkedHashSet<UserAuthority>();
        authorities.stream().sorted(Comparator.comparing(GrantedAuthority::getAuthority)).forEach(i -> sortedAuthorities.add((UserAuthority)i));
        return sortedAuthorities;
    }

    public CustomUserDetails(String username, String password, UsuarioModoAutenticacao modoAutenticacao, Collection<UserAuthority> authorities) {
        this(username, password, 0L, true, true, true, true, modoAutenticacao, authorities);
    }

    public long getExpires() {
        return this.expires;
    }

    public void setExpires(long expires) {
        this.expires = expires;
    }

    public Collection<UserAuthority> getAuthorities() {
        return this.authorities;
    }

    @JsonIgnore
    public Object getCredentials() {
        return this.password;
    }

    @JsonIgnore
    public Object getDetails() {
        return this;
    }

    @JsonIgnore
    public Object getPrincipal() {
        return this;
    }

    @JsonIgnore
    public boolean isAuthenticated() {
        return true;
    }

    public void setAuthenticated(boolean isAuthenticated) throws IllegalArgumentException {
    }

    @JsonIgnore
    public String getPassword() {
        return this.password;
    }

    @JsonProperty
    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isAccountNonExpired() {
        return this.accountNonExpired;
    }

    public boolean isAccountNonLocked() {
        return this.accountNonLocked;
    }

    public boolean isCredentialsNonExpired() {
        return this.credentialsNonExpired;
    }

    public void eraseCredentials() {
        this.password = null;
    }

    public long getUserId() {
        return this.userId;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Map<String, UserAuthority> getRoles() {
        HashMap<String, UserAuthority> roles = new HashMap<String, UserAuthority>();
        for (UserAuthority userAuthority : this.authorities) {
            roles.put(userAuthority.getAuthority(), userAuthority);
        }
        return roles;
    }

    public void setRoles(Map<String, UserAuthority> roles) {
        this.authorities = Sets.newHashSet(roles.values());
    }

    public UsuarioModoAutenticacao getModoAutenticacao() {
        return this.modoAutenticacao;
    }

    @JsonIgnore
    public String getName() {
        return this.username;
    }

    @Generated
    public String toString() {
        return "CustomUserDetails(username=" + this.getUsername() + ", password=" + this.getPassword() + ", authorities=" + String.valueOf(this.getAuthorities()) + ", accountNonExpired=" + this.isAccountNonExpired() + ", accountNonLocked=" + this.isAccountNonLocked() + ", credentialsNonExpired=" + this.isCredentialsNonExpired() + ", enabled=" + this.isEnabled() + ", expires=" + this.getExpires() + ", userId=" + this.getUserId() + ", modoAutenticacao=" + String.valueOf(this.getModoAutenticacao()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomUserDetails)) {
            return false;
        }
        CustomUserDetails other = (CustomUserDetails)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        return !(this$username == null ? other$username != null : !this$username.equals(other$username));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CustomUserDetails;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        return result;
    }
}

