/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.resource.web;

import br.com.elotech.di.resource.web.EloStepExecutionInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import lombok.Generated;
import org.springframework.batch.admin.web.JobExecutionInfo;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.StepExecution;

public class EloJobExecutionInfo {
    private final JobExecutionInfo jobExecutionInfo;
    private final List<EloStepExecutionInfo> steps;
    private final String status;

    public EloJobExecutionInfo(JobExecution jobExecution, TimeZone timeZone) {
        this.jobExecutionInfo = new JobExecutionInfo(jobExecution, timeZone);
        this.status = jobExecution.getStatus().name();
        ArrayList stepsInfo = Lists.newArrayList();
        for (StepExecution stepExecution : jobExecution.getStepExecutions()) {
            stepsInfo.add(new EloStepExecutionInfo(stepExecution, timeZone));
        }
        this.steps = Collections.unmodifiableList(stepsInfo);
    }

    public TimeZone getTimeZone() {
        return this.jobExecutionInfo.getTimeZone();
    }

    public String getName() {
        return this.jobExecutionInfo.getName();
    }

    public Long getId() {
        return this.jobExecutionInfo.getId();
    }

    public int getStepExecutionCount() {
        return this.jobExecutionInfo.getStepExecutionCount();
    }

    public Long getJobId() {
        return this.jobExecutionInfo.getJobId();
    }

    public String getStartDate() {
        return this.jobExecutionInfo.getStartDate();
    }

    public String getStartTime() {
        return this.jobExecutionInfo.getStartTime();
    }

    public String getDuration() {
        return this.jobExecutionInfo.getDuration();
    }

    public boolean isRestartable() {
        return this.jobExecutionInfo.isRestartable();
    }

    public boolean isAbandonable() {
        return this.jobExecutionInfo.isAbandonable();
    }

    public boolean isStoppable() {
        return this.jobExecutionInfo.isStoppable();
    }

    public String getJobParametersString() {
        return this.jobExecutionInfo.getJobParametersString();
    }

    public Properties getJobParameters() {
        return this.jobExecutionInfo.getJobParameters();
    }

    public List<EloStepExecutionInfo> getSteps() {
        return this.steps;
    }

    public String getStatus() {
        return this.status;
    }

    @Generated
    public String toString() {
        return "EloJobExecutionInfo(jobExecutionInfo=" + String.valueOf(this.jobExecutionInfo) + ", steps=" + String.valueOf(this.getSteps()) + ", status=" + this.getStatus() + ")";
    }
}

