/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.resource.support;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.jpa.hibernate.envers.RevisionReader;
import br.com.elotech.core.jpa.hibernate.envers.RevisionRecord;
import br.com.elotech.core.metamodel.MetaModelField;
import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.core.utils.ReflectionUtils;
import br.com.elotech.core.validation.EloValidatorPackage;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public class AbstractController<T extends EloEntity<K>, K extends Serializable>
extends CrudResource<T, K> {
    @Autowired
    private RevisionReader revisionReader;
    @Autowired
    private ObjectMapper objectMapper;
    private final Class<T> typeOfEntity = ReflectionUtils.getClassParameterizedType(this.getClass());

    @RequestMapping(method={RequestMethod.GET}, value={"/revisions/{id}"})
    public ResponseEntity<List<RevisionRecord<T>>> getRevision(@PathVariable(value="id") K id) {
        return ResponseEntity.ok((Object)this.revisionReader.findHistory(this.typeOfEntity, id));
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/revisions/{child}/{id}"})
    public ResponseEntity<List<RevisionRecord<T>>> getRevisionChild(@PathVariable(value="id") K id, @PathVariable(value="child") String child) {
        MetaModelField field = this.getMetaModel().findFieldByPath(child);
        if (field != null) {
            Class childClass = field.getClazz();
            return ResponseEntity.ok((Object)this.revisionReader.findHistory(childClass, id));
        }
        throw RestException.status((HttpStatus)HttpStatus.BAD_REQUEST, (String)String.format("Atributo %s n\u00e3o encontrada na entidade %s", child, this.getMetaModel().getClazz().getSimpleName()));
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/revisions/delete"})
    public ResponseEntity<List<RevisionRecord<T>>> revisionsDelete() {
        return ResponseEntity.ok((Object)this.revisionReader.findDeletes(this.typeOfEntity));
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/validate/{fieldName}"}, consumes={"application/json"})
    public ResponseEntity<Void> validate(HttpServletRequest request, @PathVariable(value="fieldName") String fieldName) {
        String jsonString = IOUtils.toString((InputStream)request.getInputStream(), (Charset)StandardCharsets.UTF_8);
        EloValidatorPackage eloValidatorPackage = EloValidatorPackage.desserializeFromJson((ObjectMapper)this.objectMapper, (Class)this.typeOfEntity, (String)fieldName, (String)jsonString);
        this.getCrudService().validateChild((EloEntity)eloValidatorPackage.getRoot(), eloValidatorPackage.getChild(), fieldName);
        return ResponseEntity.ok().build();
    }
}

