/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.resource.dto;

import br.com.elotech.di.domain.Entidade;
import br.com.elotech.di.domain.Grupo;
import br.com.elotech.di.domain.Recurso;
import br.com.elotech.di.domain.Rg;
import br.com.elotech.di.domain.UF;
import br.com.elotech.di.domain.Usuario;
import br.com.elotech.di.domain.UsuarioEntidade;
import br.com.elotech.di.domain.UsuarioModulo;
import br.com.elotech.di.resource.dto.UnicoMapper;
import br.com.elotech.di.resource.dto.UnicoMapperImpl;
import br.com.elotech.di.resource.dto.UnicoModuloMapper;
import br.com.elotech.unico.client.domain.EntidadeDTO;
import br.com.elotech.unico.client.domain.GrupoDTO;
import br.com.elotech.unico.client.domain.RecursoDTO;
import br.com.elotech.unico.client.domain.RgDTO;
import br.com.elotech.unico.client.domain.UsuarioDTO;
import br.com.elotech.unico.client.domain.UsuarioEntidadeDTO;
import br.com.elotech.unico.client.domain.UsuarioModoAutenticacao;
import br.com.elotech.unico.client.domain.UsuarioModuloDTO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UnicoMapperImpl
implements UnicoMapper {
    @Autowired
    private UnicoModuloMapper unicoModuloMapper;

    public UsuarioDTO toUsuarioDTO(Usuario usuario) {
        Set set;
        List list_;
        if (usuario == null) {
            return null;
        }
        UsuarioDTO usuarioDTO = new UsuarioDTO();
        usuarioDTO.setId(usuario.getId());
        usuarioDTO.setUsuario(usuario.getUsuario());
        usuarioDTO.setAtivo(usuario.getAtivo());
        usuarioDTO.setEmail(usuario.getEmail());
        usuarioDTO.setNome(usuario.getNome());
        usuarioDTO.setCpf(usuario.getCpf());
        usuarioDTO.setCargo(usuario.getCargo());
        usuarioDTO.setMatricula(usuario.getMatricula());
        usuarioDTO.setUsuarioResponsavel(this.toUsuarioDTO(usuario.getUsuarioResponsavel()));
        usuarioDTO.setRg(this.toRgDTO(usuario.getRg()));
        usuarioDTO.setContaBloqueada(usuario.getContaBloqueada());
        usuarioDTO.setSenhaExpirada(usuario.getSenhaExpirada());
        usuarioDTO.setModoAutenticacao(this.toUsuarioModoAutenticacao(usuario.getModoAutenticacao()));
        usuarioDTO.setUsuarioOriginal(usuario.getUsuarioOriginal());
        usuarioDTO.setInvalido(usuario.getInvalido());
        List list = this.usuarioEntidadeListToUsuarioEntidadeDTOList(usuario.getEntidades());
        if (list != null) {
            usuarioDTO.setEntidades(list);
        }
        if ((list_ = this.usuarioModuloListToUsuarioModuloDTOList(usuario.getModulos())) != null) {
            usuarioDTO.setModulos(list_);
        }
        if ((set = this.grupoSetToGrupoDTOSet(usuario.getGrupos())) != null) {
            usuarioDTO.setGrupos(set);
        }
        this.mapperRecursos(usuario, usuarioDTO);
        return usuarioDTO;
    }

    public UsuarioModoAutenticacao toUsuarioModoAutenticacao(br.com.elotech.di.domain.UsuarioModoAutenticacao usuarioModoAutenticacao) {
        if (usuarioModoAutenticacao == null) {
            return null;
        }
        return switch (1.$SwitchMap$br$com$elotech$di$domain$UsuarioModoAutenticacao[usuarioModoAutenticacao.ordinal()]) {
            case 1 -> UsuarioModoAutenticacao.INTERNO;
            case 2 -> UsuarioModoAutenticacao.SERVIDOR_LDAP;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf(usuarioModoAutenticacao));
        };
    }

    public RgDTO toRgDTO(Rg rg) {
        if (rg == null) {
            return null;
        }
        RgDTO rgDTO_ = new RgDTO();
        rgDTO_.setUf(this.rgUfSigla(rg));
        rgDTO_.setNumero(rg.getNumero());
        rgDTO_.setDataEmissao(rg.getDataEmissao());
        rgDTO_.setOrgaoEmissor(rg.getOrgaoEmissor());
        return rgDTO_;
    }

    public UsuarioModuloDTO toUsuarioModuloDTO(UsuarioModulo usuarioModulo) {
        if (usuarioModulo == null) {
            return null;
        }
        UsuarioModuloDTO usuarioModuloDTO_ = new UsuarioModuloDTO();
        usuarioModuloDTO_.setId(usuarioModulo.getId());
        usuarioModuloDTO_.setModulo(this.unicoModuloMapper.toModuloDTO(usuarioModulo.getModulo()));
        usuarioModuloDTO_.setPrincipal(usuarioModulo.getPrincipal());
        return usuarioModuloDTO_;
    }

    public GrupoDTO toGrupoDTO(Grupo grupo) {
        if (grupo == null) {
            return null;
        }
        GrupoDTO grupoDTO_ = new GrupoDTO();
        grupoDTO_.setId(grupo.getId());
        grupoDTO_.setNome(grupo.getNome());
        return grupoDTO_;
    }

    public RecursoDTO toRecursoDTO(Recurso recurso) {
        if (recurso == null) {
            return null;
        }
        RecursoDTO recursoDTO = new RecursoDTO();
        recursoDTO.setId(recurso.getId());
        recursoDTO.setNome(recurso.getNome());
        recursoDTO.setDescricao(recurso.getDescricao());
        recursoDTO.setFuncionalidade(recurso.getFuncionalidade());
        recursoDTO.setModulo(this.unicoModuloMapper.toModuloDTO(recurso.getModulo()));
        return recursoDTO;
    }

    public UsuarioEntidadeDTO toUsuarioEntidadeDTO(UsuarioEntidade usuarioEntidade) {
        if (usuarioEntidade == null) {
            return null;
        }
        UsuarioEntidadeDTO usuarioEntidadeDTO_ = new UsuarioEntidadeDTO();
        usuarioEntidadeDTO_.setId(usuarioEntidade.getId());
        usuarioEntidadeDTO_.setEntidade(this.toEntidadeDTO(usuarioEntidade.getEntidade()));
        usuarioEntidadeDTO_.setPrincipal(usuarioEntidade.getPrincipal());
        return usuarioEntidadeDTO_;
    }

    public EntidadeDTO toEntidadeDTO(Entidade entidade) {
        if (entidade == null) {
            return null;
        }
        EntidadeDTO entidadeDTO_ = new EntidadeDTO();
        entidadeDTO_.setId(entidade.getId());
        entidadeDTO_.setNome(entidade.getNome());
        entidadeDTO_.setEntidadePrincipal(entidade.getEntidadePrincipal());
        entidadeDTO_.setIdentificacaoTCE(entidade.getIdentificacaoTCE());
        entidadeDTO_.setTipo(entidade.getTipo());
        entidadeDTO_.setEntidadeConsole(entidade.getEntidadeConsole());
        entidadeDTO_.setSiglaUF(entidade.getSiglaUF());
        entidadeDTO_.setCnpj(entidade.getCnpj());
        if (entidade.getBrasao() != null) {
            byte[] brasao = entidade.getBrasao();
            entidadeDTO_.setBrasao(Arrays.copyOf(brasao, brasao.length));
        }
        return entidadeDTO_;
    }

    protected List<UsuarioEntidadeDTO> usuarioEntidadeListToUsuarioEntidadeDTOList(List<UsuarioEntidade> list) {
        if (list == null) {
            return null;
        }
        ArrayList<UsuarioEntidadeDTO> list_ = new ArrayList<UsuarioEntidadeDTO>();
        for (UsuarioEntidade usuarioEntidade : list) {
            list_.add(this.toUsuarioEntidadeDTO(usuarioEntidade));
        }
        return list_;
    }

    protected List<UsuarioModuloDTO> usuarioModuloListToUsuarioModuloDTOList(List<UsuarioModulo> list) {
        if (list == null) {
            return null;
        }
        ArrayList<UsuarioModuloDTO> list_ = new ArrayList<UsuarioModuloDTO>();
        for (UsuarioModulo usuarioModulo : list) {
            list_.add(this.toUsuarioModuloDTO(usuarioModulo));
        }
        return list_;
    }

    protected Set<GrupoDTO> grupoSetToGrupoDTOSet(Set<Grupo> set) {
        if (set == null) {
            return null;
        }
        HashSet<GrupoDTO> set_ = new HashSet<GrupoDTO>();
        for (Grupo grupo : set) {
            set_.add(this.toGrupoDTO(grupo));
        }
        return set_;
    }

    private String rgUfSigla(Rg rg) {
        if (rg == null) {
            return null;
        }
        UF uf = rg.getUf();
        if (uf == null) {
            return null;
        }
        String sigla = uf.getSigla();
        if (sigla == null) {
            return null;
        }
        return sigla;
    }
}

