/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.resource.dto;

import br.com.elotech.di.domain.Entidade;
import br.com.elotech.di.domain.Grupo;
import br.com.elotech.di.domain.Recurso;
import br.com.elotech.di.domain.Rg;
import br.com.elotech.di.domain.Usuario;
import br.com.elotech.di.domain.UsuarioEntidade;
import br.com.elotech.di.domain.UsuarioModulo;
import br.com.elotech.di.resource.dto.UnicoModuloMapper;
import br.com.elotech.di.resource.dto.UnicoUsuarioSeletorMapper;
import br.com.elotech.unico.client.domain.EntidadeDTO;
import br.com.elotech.unico.client.domain.GrupoDTO;
import br.com.elotech.unico.client.domain.RecursoDTO;
import br.com.elotech.unico.client.domain.RgDTO;
import br.com.elotech.unico.client.domain.UsuarioDTO;
import br.com.elotech.unico.client.domain.UsuarioEntidadeDTO;
import br.com.elotech.unico.client.domain.UsuarioModoAutenticacao;
import br.com.elotech.unico.client.domain.UsuarioModuloDTO;
import java.util.Set;
import java.util.stream.Collectors;
import org.mapstruct.AfterMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;

@Mapper(componentModel="spring", uses={UnicoModuloMapper.class, UnicoUsuarioSeletorMapper.class})
public interface UnicoMapper {
    @Mappings(value={@Mapping(target="recursos", ignore=true), @Mapping(target="favoritos", ignore=true), @Mapping(target="entidadePadrao", ignore=true)})
    public UsuarioDTO toUsuarioDTO(Usuario var1);

    public UsuarioModoAutenticacao toUsuarioModoAutenticacao(br.com.elotech.di.domain.UsuarioModoAutenticacao var1);

    @Mapping(target="uf", source="rg.uf.sigla")
    public RgDTO toRgDTO(Rg var1);

    public UsuarioModuloDTO toUsuarioModuloDTO(UsuarioModulo var1);

    public GrupoDTO toGrupoDTO(Grupo var1);

    public RecursoDTO toRecursoDTO(Recurso var1);

    public UsuarioEntidadeDTO toUsuarioEntidadeDTO(UsuarioEntidade var1);

    public EntidadeDTO toEntidadeDTO(Entidade var1);

    @AfterMapping
    default public void mapperRecursos(Usuario usuario, @MappingTarget UsuarioDTO dto) {
        Set permissoes = usuario.getUsuarioRecursos().stream().map(Recurso::getNome).collect(Collectors.toSet());
        dto.setRecursos(permissoes);
    }
}

