/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.resource.batch;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.utils.DateUtils;
import br.com.elotech.di.batch.job.JobLauncherActiveContext;
import br.com.elotech.di.batch.job.JobUtils;
import br.com.elotech.di.config.UnicoProperties;
import br.com.elotech.di.resource.web.EloJobExecutionInfo;
import br.com.elotech.di.resource.web.EloJobInfo;
import br.com.elotech.di.resource.web.EloJobStatus;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.security.PermitAll;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobOperator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.batch.JobExecutionEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest"})
public class JobController
implements ApplicationEventPublisherAware {
    @Autowired
    private JobExplorer jobExplorer;
    @Autowired
    private JobLauncherActiveContext joLauncherActiveContext;
    @Autowired
    private JobUtils jobUtils;
    @Autowired
    private JobOperator jobOperator;
    @Autowired
    private UnicoProperties unicoProperties;
    @Autowired
    private Collection<Job> jobs;
    private ApplicationEventPublisher publisher;
    private final Lock lock = new ReentrantLock();

    @GetMapping(value={"/jobs"})
    @PreAuthorize(value="hasRole('ADMIN') or hasAuthority('UNIFICACAO_READ')")
    public ResponseEntity<List<EloJobInfo>> getJobs() {
        return ResponseEntity.ok((Object)this.getAllJobs());
    }

    private List<EloJobInfo> getAllJobs() {
        ArrayList<EloJobInfo> jobsExecutions = new ArrayList<EloJobInfo>();
        for (Job job : this.jobs) {
            List executions = this.jobUtils.getJobExecutions(job.getName());
            if (executions.isEmpty()) {
                jobsExecutions.add(new EloJobInfo(job.getName(), 0, new ArrayList()));
                continue;
            }
            jobsExecutions.addAll(executions);
        }
        return jobsExecutions;
    }

    @GetMapping(value={"/jobs/{jobName}"})
    @PreAuthorize(value="hasRole('ADMIN') or hasAuthority('UNIFICACAO_READ')")
    public ResponseEntity<List<EloJobExecutionInfo>> details(@PathVariable(value="jobName") String jobName, @RequestParam(defaultValue="0") int startJobInstance, @RequestParam(defaultValue="20") int pageSize) {
        List jobsInstances = this.jobExplorer.getJobInstances(jobName, startJobInstance, pageSize);
        ArrayList jobsExecutionInfo = Lists.newArrayList();
        for (JobInstance jobInstance : jobsInstances) {
            List executions = this.jobExplorer.getJobExecutions(jobInstance);
            for (JobExecution jobExecution : executions) {
                EloJobExecutionInfo jobExecutionInfo = new EloJobExecutionInfo(jobExecution, DateUtils.TIMEZONE_SAO_PAULO);
                jobsExecutionInfo.add(jobExecutionInfo);
            }
        }
        return ResponseEntity.ok((Object)jobsExecutionInfo);
    }

    @DeleteMapping(value={"/jobs/{jobName}"})
    @PreAuthorize(value="hasRole('ADMIN') or hasAuthority('UNIFICACAO_CREATE')")
    public ResponseEntity<String> stop(@PathVariable(value="jobName") String jobName) {
        for (Job job : this.jobs) {
            if (!job.getName().equals(jobName)) continue;
            JobExecution execution = this.jobUtils.getLastJobExecution(jobName);
            if (execution != null && execution.getStatus().equals((Object)BatchStatus.STARTED)) {
                this.jobOperator.stop(execution.getId().longValue());
                continue;
            }
            throw RestException.notFound((String)("Job com nome: " + jobName + " n\u00e3o est\u00e1 rodando."));
        }
        return ResponseEntity.ok((Object)"Enviado sinal de parada ao job");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PostMapping(value={"/jobs/{jobName}"})
    @PreAuthorize(value="hasRole('ADMIN') or hasAuthority('UNIFICACAO_CREATE')")
    public ResponseEntity<String> launch(@PathVariable(value="jobName") String jobName) {
        if (!this.lock.tryLock()) throw RestException.notFound((String)("Tarefa " + jobName + " j\u00e1 est\u00e1 rodando."));
        try {
            Job job;
            Iterator iterator = this.jobs.iterator();
            do {
                if (!iterator.hasNext()) throw RestException.notFound((String)("Job n\u00e3o encontrado com nome: " + jobName));
            } while (!(job = (Job)iterator.next()).getName().equals(jobName));
            JobParameters lastJobParameters = this.jobUtils.getLastJobParameters(jobName);
            if (this.jobUtils.isAllCompleteExecutions(jobName)) {
                if (this.jobsOnceTime(jobName)) {
                    throw RestException.status((HttpStatus)HttpStatus.BAD_REQUEST, (String)"Job j\u00e1 conclu\u00eddo com sucesso");
                }
                lastJobParameters = new JobParametersBuilder().addLong("time", Long.valueOf(System.currentTimeMillis())).addString("tenant", TenantContextHolder.getTenantId().orElse("")).toJobParameters();
            }
            if (this.alreadyExecuteUnificacaoCompleta(jobName)) {
                throw RestException.status((HttpStatus)HttpStatus.BAD_REQUEST, (String)"Job j\u00e1 conclu\u00eddo com sucesso");
            }
            JobExecution execution = this.joLauncherActiveContext.launch(job, lastJobParameters);
            if (this.publisher != null) {
                this.publisher.publishEvent((ApplicationEvent)new JobExecutionEvent(execution));
            }
            if (execution.getStatus().isUnsuccessful()) {
                throw RestException.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR, (String)String.format("%s: %s", execution.getStatus(), this.jobUtils.getFailureMessages(execution)));
            }
            ResponseEntity responseEntity = ResponseEntity.ok((Object)"Job conclu\u00eddo com sucesso");
            return responseEntity;
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean alreadyExecuteUnificacaoCompleta(String jobName) {
        return jobName.equals("Unifica_Usuario") && this.jobUtils.getJobExecutionStatus("Unifica\u00e7\u00e3o").equals((Object)BatchStatus.COMPLETED);
    }

    private boolean jobsOnceTime(String jobName) {
        return jobName.equals("Unifica\u00e7\u00e3o") || jobName.equals("Unifica_Usuario");
    }

    @GetMapping(value={"/jobs/{jobName}/status"})
    @PermitAll
    public ResponseEntity<EloJobStatus> jobNameStatus(@PathVariable(value="jobName") String jobName) {
        if (Boolean.TRUE.equals(this.unicoProperties.getCloud())) {
            return ResponseEntity.ok((Object)new EloJobStatus(BatchStatus.COMPLETED));
        }
        return ResponseEntity.ok((Object)new EloJobStatus(this.jobUtils.getJobExecutionStatus(jobName)));
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.publisher = applicationEventPublisher;
    }
}

