/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.resource;

import br.com.elotech.core.metamodel.MetaModel;
import br.com.elotech.core.metamodel.loader.MetaModelLoader;
import br.com.elotech.di.domain.Usuario;
import br.com.elotech.di.repository.UsuariosLDAP;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/ldap/usuarios"})
@ConditionalOnProperty(name={"ldap.enabled"}, havingValue="true", matchIfMissing=false)
public class UsuariosLDAPResource {
    @Autowired
    private UsuariosLDAP usuariosLDAP;

    @RequestMapping(method={RequestMethod.GET}, value={"/{userFilter}"})
    public ResponseEntity<Page<Usuario>> getUsuariosLDAPaginateWithFilter(Pageable pageable, @PathVariable(value="userFilter") String userFilter) {
        return ResponseEntity.ok((Object)this.usuariosLDAP.search(pageable, userFilter));
    }

    @RequestMapping(method={RequestMethod.GET})
    public ResponseEntity<Page<Usuario>> getUsuariosLDAPPaginate(Pageable pageable) {
        return ResponseEntity.ok((Object)this.usuariosLDAP.search(pageable));
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/model"})
    public ResponseEntity<MetaModel> model(@RequestParam(value="path", defaultValue="") String path) {
        MetaModel metaModel = MetaModelLoader.newMetaModel(Usuario.class);
        if (!"".equals(path)) {
            metaModel = metaModel.byPath(path);
        }
        return ResponseEntity.ok((Object)metaModel);
    }
}

