/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.resource;

import br.com.elotech.console.dto.RolesUsuarioDTO;
import br.com.elotech.console.dto.UsuarioPayloadDTO;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.di.domain.Entidade;
import br.com.elotech.di.domain.Recurso;
import br.com.elotech.di.domain.Usuario;
import br.com.elotech.di.domain.UsuarioLogado;
import br.com.elotech.di.domain.dto.MensagemDTO;
import br.com.elotech.di.domain.support.UsuarioTrocaSenha;
import br.com.elotech.di.resource.dto.UnicoMapper;
import br.com.elotech.di.resource.dto.UnicoModuloMapper;
import br.com.elotech.di.resource.support.AbstractController;
import br.com.elotech.di.security.CustomUserDetails;
import br.com.elotech.di.service.MensagemService;
import br.com.elotech.di.service.UsuarioLogadoService;
import br.com.elotech.di.service.UsuarioSeletorService;
import br.com.elotech.di.service.UsuarioService;
import br.com.elotech.di.service.UsuarioUnificarService;
import br.com.elotech.di.utils.EloGeneratesPasswordUtils;
import br.com.elotech.di.utils.EloMaskUtils;
import br.com.elotech.unico.client.domain.EntidadeDTO;
import br.com.elotech.unico.client.domain.UsuarioDTO;
import br.com.elotech.unico.client.dto.ModuloDTO;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.CacheControl;
import org.springframework.http.ResponseEntity;
import org.springframework.mail.MailException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/rest/usuarios", "/api/usuarios"})
public class UsuarioResource
extends AbstractController<Usuario, Long> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UsuarioResource.class);
    @Autowired
    private UserDetailsService userDetailsService;
    @Autowired
    @Inject
    private UnicoModuloMapper unicoModuloMapper;
    @Autowired
    private UnicoMapper unicoMapper;
    @Autowired
    private UsuarioSeletorService usuarioSeletorService;
    @Autowired
    private UsuarioUnificarService usuarioUnificarService;
    @Autowired
    private MensagemService mensagemService;
    @Autowired
    private UsuarioLogadoService usuarioLogadoService;

    @GetMapping(value={"/byname/{username}"})
    public ResponseEntity<Usuario> findByName(@PathVariable(value="username") String username) {
        Usuario entity = this.getUsuarioService().findByUsuario(username);
        if (entity == null) {
            throw RestException.notFound();
        }
        return ResponseEntity.ok((Object)entity);
    }

    @GetMapping(value={"/me"})
    public ResponseEntity<UsuarioDTO> me(Authentication authentication) {
        Usuario usuarioLogado = this.getUsuarioService().findByUsuario(authentication.getName());
        if (Objects.isNull(usuarioLogado)) {
            LOGGER.warn("N\u00e3o foi poss\u00edvel encontrar o usu\u00e1rio {} no banco de dados ao requisitar /api/usuarios/me", (Object)authentication.getName());
            throw new AccessDeniedException(String.format("O usu\u00e1rio %s n\u00e3o tem acesso ao recurso solicitado", authentication.getName()));
        }
        UsuarioDTO usuarioDTO = this.unicoMapper.toUsuarioDTO(usuarioLogado);
        Optional entidadePadraoUsuario = this.getUsuarioService().getEntidadePadraoUsuario(usuarioDTO.getUsuario());
        if (entidadePadraoUsuario.isPresent()) {
            EntidadeDTO entidadeDTO = this.unicoMapper.toEntidadeDTO((Entidade)entidadePadraoUsuario.get());
            usuarioDTO.setEntidadePadrao(entidadeDTO);
        }
        List favoritosDTO = this.usuarioSeletorService.findUsuarioSeletorFavoritos(authentication.getName());
        usuarioDTO.setFavoritos(favoritosDTO);
        CustomUserDetails userDetails = (CustomUserDetails)authentication.getPrincipal();
        Set recursos = userDetails.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toSet());
        usuarioDTO.setRecursos(recursos);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.empty())).body((Object)usuarioDTO);
    }

    @GetMapping(value={"/duplicados/{username}"})
    public ResponseEntity<List<Usuario>> findUsuarioDuplicados(@PathVariable(value="username") String username) {
        List usuarios = this.getUsuarioService().findAllByUsuarioOriginal(username);
        return ResponseEntity.ok((Object)Lists.newArrayList((Iterable)usuarios));
    }

    @GetMapping(value={"/roles"})
    public ResponseEntity<RolesUsuarioDTO> getPermissoesUsuario() {
        return ResponseEntity.ok((Object)this.usuarioLogadoService.getPermissoesUsuario());
    }

    @GetMapping(value={"/usuario-logado"})
    public ResponseEntity<UsuarioLogado> getUsuarioLogado() {
        return ResponseEntity.ok((Object)this.usuarioLogadoService.getUsuarioLogado());
    }

    @PostMapping(value={"/duplicados/{usernameOriginal}/{usernamePrimary}"})
    public ResponseEntity<Long> unificaUsuariosDuplicados(@PathVariable(value="usernameOriginal") String usernameOriginal, @PathVariable(value="usernamePrimary") String usernamePrimary, UriComponentsBuilder builder, HttpServletRequest request) {
        Usuario novoUsuario = this.usuarioUnificarService.unificar(usernameOriginal, usernamePrimary);
        URI uriLocation = builder.replacePath("/usuarios/{id}").buildAndExpand(new Object[]{novoUsuario.getId()}).toUri();
        return ResponseEntity.created((URI)uriLocation).body((Object)novoUsuario.getId());
    }

    @PatchMapping(value={"/changePassword/{id}"})
    public ResponseEntity<Void> changePassword(@RequestBody UsuarioTrocaSenha usuarioTrocaSenha, @PathVariable(value="id") Long id) {
        UsuarioService service = (UsuarioService)this.getService();
        service.trocaSenha(id, usuarioTrocaSenha);
        return ResponseEntity.ok().build();
    }

    @PatchMapping(value={"/definePassword/{id}"})
    @PreAuthorize(value="hasRole('ADMIN')")
    public ResponseEntity<Void> definePassword(@RequestBody UsuarioTrocaSenha usuarioTrocaSenha, @PathVariable(value="id") Long id) {
        UsuarioService service = (UsuarioService)this.getService();
        service.defineSenha(id, usuarioTrocaSenha.getSenhaNova());
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/modulos"})
    public ResponseEntity<List<ModuloDTO>> findUsuarioModulos(Authentication authentication) {
        List modulos = this.getUsuarioService().findUsuarioModulos(authentication.getName()).stream().map(modulo -> this.unicoModuloMapper.toModuloDTO(modulo)).collect(Collectors.toList());
        return ResponseEntity.ok(modulos);
    }

    @GetMapping(value={"/authorities"})
    public ResponseEntity<Set<String>> authorities(Authentication authentication) {
        UserDetails userDetails = this.userDetailsService.loadUserByUsername(authentication.getName());
        Set authorityList = AuthorityUtils.authorityListToSet((Collection)userDetails.getAuthorities());
        return ResponseEntity.ok((Object)authorityList);
    }

    @GetMapping(value={"/usernameByModulo/{modulo}"})
    public String usernameByModulo(@PathVariable(value="modulo") String modulo) {
        Usuario entity = this.getUsuarioService().findByUsuario(SecurityContextHolder.getContext().getAuthentication().getName());
        if (entity == null) {
            throw RestException.notFound();
        }
        ModuloEnum moduloEnum = ModuloEnum.getByValue((String)modulo);
        for (Map.Entry entry : Usuario.USUARIO_MODULE_CLASS.entrySet()) {
            if (!((List)entry.getKey()).contains(moduloEnum)) continue;
            return this.getUsuarioService().getUsernameByClass(entity, (Class)entry.getValue());
        }
        return entity.getUsuario();
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{idUsuario}/recurso/{idRecurso}"})
    @Transactional
    public ResponseEntity<Void> addRecurso(@PathVariable(value="idUsuario") Long idUsuario, @PathVariable(value="idRecurso") Long idRecurso) {
        return this.operation(idUsuario, entity -> entity.getUsuarioRecursos().add(Recurso.of((Long)idRecurso)));
    }

    private ResponseEntity<Void> operation(Long idUsuario, Consumer<Usuario> consumer) {
        Usuario entity = (Usuario)this.getUsuarioService().findOne((Serializable)idUsuario);
        if (entity == null) {
            throw RestException.notFound();
        }
        consumer.accept(entity);
        return ResponseEntity.ok().build();
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{idUsuario}/recurso/{idRecurso}"})
    @Transactional
    public ResponseEntity<Void> removeRecurso(@PathVariable(value="idUsuario") Long idUsuario, @PathVariable(value="idRecurso") Long idRecurso) {
        return this.operation(idUsuario, entity -> entity.getUsuarioRecursos().removeIf(rec -> rec.getId().equals(idRecurso)));
    }

    @PatchMapping(value={"/changePasswordByUserName/{username}"})
    public ResponseEntity<Void> changePasswordByUsername(@RequestBody UsuarioTrocaSenha usuarioTrocaSenha, @PathVariable(value="username") String username) {
        UsuarioService service = (UsuarioService)this.getService();
        Usuario usuarioLoad = service.findByUsuario(username);
        if (usuarioLoad == null) {
            throw new IllegalArgumentException(String.format("Usu\u00e1rio n\u00e3o encontrado com username %s.", username));
        }
        service.trocaSenha(usuarioLoad.getId(), usuarioTrocaSenha);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/emailMaskByUsuario/{userName}"})
    public String emailMaskByUsuario(@PathVariable(value="userName") String userName) {
        UsuarioService service = (UsuarioService)this.getService();
        Usuario usuarioLoad = service.findByUsuario(userName);
        if (usuarioLoad == null) {
            throw RestException.notFound();
        }
        return EloMaskUtils.maskEmailAddress((String)usuarioLoad.getEmail());
    }

    @GetMapping(value={"/esqueciMinhaSenha/{userName}"})
    public ResponseEntity<Boolean> esqueciMinhaSenha(@PathVariable(value="userName") String userName) throws InterruptedException, ExecutionException {
        UsuarioService service = (UsuarioService)this.getService();
        Usuario usuarioLoad = service.findByUsuario(userName);
        if (usuarioLoad == null) {
            throw RestException.notFound();
        }
        usuarioLoad.setSenha(EloGeneratesPasswordUtils.randomPassword());
        MensagemDTO mensagem = new MensagemDTO();
        mensagem.setAssunto("Nova Senha");
        mensagem.setEmail(usuarioLoad.getEmail());
        mensagem.setMensagem("Nova senha: " + usuarioLoad.getSenha());
        mensagem.setNome(usuarioLoad.getNome());
        try {
            Boolean done = this.mensagemService.enviarMensagem(mensagem, mensagem.getEmail());
            if (done.booleanValue()) {
                service.defineSenha(usuarioLoad.getId(), usuarioLoad.getSenha());
                return ResponseEntity.ok((Object)done);
            }
        }
        catch (MailException e) {
            throw new IllegalStateException("Falha ao enviar email!");
        }
        return ResponseEntity.ok((Object)false);
    }

    private UsuarioService getUsuarioService() {
        return (UsuarioService)this.getCrudService();
    }

    @PostMapping(value={"/sincronizar"})
    public ResponseEntity<Usuario> sincronizar(@RequestBody UsuarioPayloadDTO payload) {
        return ResponseEntity.ok((Object)this.getUsuarioService().createOrUpdateUsuario(payload));
    }

    @GetMapping(value={"/entidades-by-usuario"})
    public ResponseEntity<List<Entidade>> findAllEntidadesByUsuario() {
        return ResponseEntity.ok((Object)this.getUsuarioService().findAllEntidadesByUsuario());
    }
}

