/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.resource;

import br.com.elotech.di.service.UnidadeService;
import br.com.elotech.unico.client.dto.CheckUsuarioUnidadeDTO;
import br.com.elotech.unico.client.dto.PessoaDTO;
import br.com.elotech.unico.client.dto.SearchUsuarioUnidadeDTO;
import br.com.elotech.unico.client.dto.UnidadeDTO;
import java.util.List;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/unidade"})
public class UnidadeResource {
    private final UnidadeService unidadeService;

    @GetMapping(value={"/{codigo}"})
    public ResponseEntity<UnidadeDTO> getUnidadeByCodigo(@PathVariable String codigo, @RequestHeader Long entidade) {
        return ResponseEntity.ok((Object)this.unidadeService.getByCodigo(codigo, entidade));
    }

    @GetMapping(value={"/por-usuario/{cpfCnpj}"})
    public ResponseEntity<UnidadeDTO> getUnidadeByPessoa(@PathVariable String cpfCnpj, @RequestHeader Long entidade) {
        return ResponseEntity.ok((Object)this.unidadeService.getUnidadeFromUsuario(cpfCnpj, entidade));
    }

    @PostMapping(value={"/usuario-pertence-unidade"})
    public ResponseEntity<Boolean> checkUsuarioPertenceAUnidade(@RequestBody CheckUsuarioUnidadeDTO checkDTO, @RequestHeader Long entidade) {
        return ResponseEntity.ok((Object)this.unidadeService.usuarioPertenceAUnidade(checkDTO.getCpfCnpj(), checkDTO.getUnidades(), entidade));
    }

    @GetMapping(value={"/{unidade}/usuarios"})
    public ResponseEntity<List<PessoaDTO>> getUsuariosFromUnidade(@PathVariable String unidade, @RequestHeader Long entidade) {
        return ResponseEntity.ok((Object)this.unidadeService.getUsuariosFromUnidade(unidade, entidade));
    }

    @GetMapping(value={"/{unidade}/responsavel"})
    public ResponseEntity<PessoaDTO> getResponsavelFromUnidade(@PathVariable String unidade, @RequestHeader Long entidade) {
        return ResponseEntity.ok((Object)this.unidadeService.getResponsavelFromUnidade(unidade, entidade));
    }

    @GetMapping
    public ResponseEntity<List<UnidadeDTO>> searchUnidade(@RequestParam(required=false, defaultValue="") String search, @RequestHeader Long entidade) {
        return ResponseEntity.ok((Object)this.unidadeService.searchUnidades(search, entidade));
    }

    @PostMapping(value={"/search-usuarios"})
    public ResponseEntity<List<PessoaDTO>> searchUsuariosInUnidades(@RequestBody SearchUsuarioUnidadeDTO searchDTO, @RequestHeader Long entidade) {
        return ResponseEntity.ok((Object)this.unidadeService.searchUsuariosInUnidades(searchDTO.getSearch(), searchDTO.getUnidades(), entidade));
    }

    @Generated
    public UnidadeResource(UnidadeService unidadeService) {
        this.unidadeService = unidadeService;
    }
}

