/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.resource;

import br.com.elotech.core.exception.RecordNotFoundException;
import br.com.elotech.di.dto.StatusRepublishDTO;
import br.com.elotech.di.dto.enums.ExchangesEnum;
import br.com.elotech.di.dto.enums.StatusPublishEnum;
import br.com.elotech.di.service.sincronizar.AbstractSincronizarService;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/sincronizar"})
public class SincronizarResource {
    private final List<AbstractSincronizarService> services;
    private final RedisTemplate<String, StatusRepublishDTO> redisTemplate;

    @PostMapping
    public ResponseEntity<Void> sincronizar(@RequestParam ExchangesEnum exchange, @RequestParam String search) {
        StatusPublishEnum statusPublishEnum = this.findRedis(exchange).getStatus();
        if (statusPublishEnum.isEmExecucao()) {
            throw new IllegalArgumentException("A fila j\u00e1 est\u00e1 sendo executada");
        }
        AbstractSincronizarService sincronizarService = this.getService(exchange);
        sincronizarService.sincronizar(search);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/filas"})
    public ResponseEntity<List<StatusRepublishDTO>> getFilas() {
        List statusRepublishList = Arrays.stream(ExchangesEnum.values()).map(arg_0 -> this.findRedis(arg_0)).collect(Collectors.toList());
        return ResponseEntity.ok(statusRepublishList);
    }

    @GetMapping(value={"/status"})
    public ResponseEntity<StatusRepublishDTO> statusRepublish(@RequestParam ExchangesEnum exchange) {
        return ResponseEntity.ok((Object)this.findRedis(exchange));
    }

    @PostMapping(value={"/cancelar"})
    public ResponseEntity<Void> cancelar(@RequestParam ExchangesEnum exchange) {
        AbstractSincronizarService sincronizarService = this.getService(exchange);
        StatusRepublishDTO statusRepublishDTO = this.findRedis(exchange);
        sincronizarService.cancelarSincronizacao(statusRepublishDTO);
        return ResponseEntity.noContent().build();
    }

    public StatusRepublishDTO findRedis(ExchangesEnum exchange) {
        AbstractSincronizarService sincronizarService = this.getService(exchange);
        return Optional.ofNullable((StatusRepublishDTO)this.redisTemplate.opsForValue().get((Object)sincronizarService.createKey(exchange.getNome()))).orElse(StatusRepublishDTO.buildObject((ExchangesEnum)exchange, (String)""));
    }

    private AbstractSincronizarService getService(ExchangesEnum exchange) {
        return this.services.stream().filter(s -> s.appliesTo(exchange)).findFirst().orElseThrow(() -> new RecordNotFoundException(String.format("N\u00e3o encontrado servi\u00e7o de publica\u00e7\u00e3o para a fila %s", exchange)));
    }

    @Generated
    public SincronizarResource(List<AbstractSincronizarService> services, RedisTemplate<String, StatusRepublishDTO> redisTemplate) {
        this.services = services;
        this.redisTemplate = redisTemplate;
    }
}

