/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.resource;

import br.com.elotech.arquivos.domain.Arquivo;
import br.com.elotech.arquivos.domain.request.ArquivoNovoRequest;
import br.com.elotech.arquivos.domain.support.ContentType;
import br.com.elotech.arquivos.domain.support.Tenant;
import br.com.elotech.console.dto.Modulo;
import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.core.utils.web.ResponseUtils;
import br.com.elotech.di.domain.Report;
import br.com.elotech.di.dto.ReportExecutionRequest;
import br.com.elotech.di.service.ReportService;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/report"})
public class ReportResource
extends CrudResource<Report, Long> {
    public ReportService getService() {
        return (ReportService)super.getService();
    }

    @PostMapping(value={"/{reportId}/gerar"})
    public void impressao(@RequestBody(required=false) ReportExecutionRequest request, @PathVariable Long reportId, Pageable pageable, HttpServletResponse httpServletResponse) throws IOException {
        byte[] arquivoImpressao = Objects.nonNull(request) ? this.getService().impressaoAnexo(reportId, request, pageable) : this.getService().impressaoAnexo(reportId, pageable);
        ResponseUtils.writePdfToResponse((HttpServletResponse)httpServletResponse, (byte[])arquivoImpressao, (String)reportId.toString());
    }

    @PostMapping(value={"/arquivo/jasper"}, consumes={"multipart/form-data"})
    public ResponseEntity<String> createJasperFile(@RequestParam(value="files") MultipartFile file) {
        Tenant tenant = Tenant.create((String)TenantContextHolder.getCurrentTenantId());
        ArquivoNovoRequest arquivoNovoRequest = ArquivoNovoRequest.builder((Tenant)tenant, (Modulo)Modulo.OXY_PAINEL).contentType(ContentType.TEXT_PLAIN).content((InputStream)new ByteArrayInputStream(file.getBytes())).fileName(file.getName()).filePath(file.getOriginalFilename()).build();
        Arquivo response = this.getService().saveJasperFile(arquivoNovoRequest);
        return ResponseEntity.created((URI)URI.create("")).body((Object)response.getFullPath());
    }

    @GetMapping(value={"/usuarios/modulos"})
    public void modulosPorUsuario(@RequestParam(value="nome", required=false) String nome, @RequestParam(value="usuario", required=false) String usuario, @RequestParam(value="ativo", required=false) String ativo, @RequestParam(value="modulo", required=false) Long modulo, HttpServletResponse httpServletResponse) throws IOException {
        byte[] relatorio = this.getService().impressaoUsuariosModulos(nome, usuario, ativo, modulo);
        ResponseUtils.writePdfToResponse((HttpServletResponse)httpServletResponse, (byte[])relatorio, (String)"ModulosPorUsuario.pdf");
    }

    @Generated
    public ReportResource() {
    }
}

