/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.resource;

import br.com.elotech.core.metamodel.MetaModel;
import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.di.domain.QueryMetaModel;
import br.com.elotech.di.domain.ResultDTO;
import br.com.elotech.di.domain.query.AbstractQuery;
import br.com.elotech.di.domain.query.QueryField;
import br.com.elotech.di.service.QueryService;
import br.com.elotech.reportexport.exporter.ReportViewData;
import br.com.elotech.reportexport.exporter.ReportViewModel;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/query"})
public class QueryResource
extends CrudResource<AbstractQuery, Long> {
    public QueryService getService() {
        return (QueryService)super.getService();
    }

    @PostMapping(value={"/executar"})
    public ResponseEntity<ResultDTO> consultar(@RequestBody AbstractQuery query, @PageableDefault(size=20) Pageable page) {
        return ResponseEntity.ok((Object)this.getService().consultar(query, page));
    }

    @PostMapping(value={"/query-report"})
    public ReportViewModel consultar(@RequestParam String fields, @RequestBody AbstractQuery query, @PageableDefault(size=20) Pageable pageable) {
        ResultDTO result = this.getService().consultar(query, pageable);
        ReportViewData data = ReportViewData.builderImmutableMetaModel((MetaModel)new QueryMetaModel(query.getFields())).withFields(fields, Integer.valueOf(8)).withPage(result.getReportResult()).build();
        return data.toReportModelAndView();
    }

    @PostMapping(value={"/gerar-campos"})
    public ResponseEntity<List<QueryField>> gerarCampos(@RequestBody AbstractQuery query) {
        return ResponseEntity.ok((Object)this.getService().gerarCampos(query));
    }

    @GetMapping(value={"/testar/{host}"})
    public ResponseEntity<Void> testarHost(@PathVariable String host) {
        if (this.getService().testarHost("http://" + host).booleanValue()) {
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.noContent().build();
    }
}

