/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.resource;

import br.com.elotech.console.dto.UsuarioDTO;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.json.update.JsonUpdatePartial;
import br.com.elotech.core.metamodel.MetaModel;
import br.com.elotech.core.metamodel.loader.MetaModelLoader;
import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.core.utils.ReflectionUtils;
import br.com.elotech.core.web.request.ContextHolder;
import br.com.elotech.di.domain.Pessoa;
import br.com.elotech.di.domain.PessoaDisableDuplicate;
import br.com.elotech.di.domain.PessoaEndereco;
import br.com.elotech.di.domain.dto.PessoaDto;
import br.com.elotech.di.repository.PessoaDisableDuplicates;
import br.com.elotech.di.repository.Pessoas;
import br.com.elotech.di.repository.projection.PessoaExistsProjection;
import br.com.elotech.di.resource.support.AbstractController;
import br.com.elotech.di.service.PessoaDuplicatesService;
import br.com.elotech.di.service.PessoaService;
import br.com.elotech.di.service.PessoaServiceValidateModulo;
import com.google.common.base.Splitter;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/pessoas"})
public class PessoaResource
extends AbstractController<Pessoa, Long> {
    @Autowired
    private PessoaServiceValidateModulo serviceValidateModulo;
    @Autowired
    private PessoaDuplicatesService pessoaDuplicatesService;
    @Autowired
    private PessoaDisableDuplicates pessoaDisableDuplicates;
    @Autowired
    private Pessoas pessoas;

    public PessoaService getPessoaService() {
        return (PessoaService)super.getCrudService();
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/isEditable/{id}"})
    public ResponseEntity<Void> isEditable(@PathVariable(value="id") Long id) {
        this.serviceValidateModulo.valid((Pessoa)this.getService().findOne((Serializable)id), ContextHolder.getHeaderValueModulo());
        return ResponseEntity.ok().build();
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{id}/contribuinte"})
    public ResponseEntity<Pessoa> ativaContribuinte(@PathVariable(value="id") Long id, Authentication authentication) {
        Pessoa pessoa = (Pessoa)this.getService().findOne((Serializable)id);
        pessoa.setContribuinte(Boolean.TRUE);
        Pessoa saved = this.getPessoaService().saveSkippingValidation(pessoa, authentication);
        return ResponseEntity.ok((Object)saved);
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{id}/protocolo"})
    public ResponseEntity<Pessoa> ativaProtocolo(@PathVariable(value="id") Long id, Authentication authentication) {
        Pessoa pessoa = (Pessoa)this.getService().findOne((Serializable)id);
        pessoa.setProtocolo(Boolean.TRUE);
        Pessoa saved = this.getPessoaService().saveSkippingValidation(pessoa, authentication);
        return ResponseEntity.ok((Object)saved);
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{id}/fornecedor"})
    public ResponseEntity<Pessoa> ativaFornecedor(@PathVariable(value="id") Long id, Authentication authentication) {
        Pessoa pessoa = (Pessoa)this.getService().findOne((Serializable)id);
        pessoa.setFornecedor(Boolean.TRUE);
        Pessoa saved = this.getPessoaService().saveSkippingValidation(pessoa, authentication);
        return ResponseEntity.ok((Object)saved);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/duplicates", "/duplicates/{cnpj_cpf}"})
    public ResponseEntity<Page<PessoaDto>> getDuplicates(@PathVariable(value="cnpj_cpf") Optional<String> cnpjCpf, Pageable pageable) {
        return cnpjCpf.map(s -> ResponseEntity.ok((Object)this.pessoaDuplicatesService.findDuplicatesCnpjCpf(pageable, s))).orElseGet(() -> ResponseEntity.ok((Object)this.pessoaDuplicatesService.findDuplicates(pageable)));
    }

    @GetMapping(value={"/exists/{cnpjcpf}"})
    public ResponseEntity<Page<PessoaExistsProjection>> exists(@PathVariable(value="cnpjcpf") String cnpjcpf, Pageable pageable) {
        return ResponseEntity.ok((Object)this.pessoaDuplicatesService.findExistsCnpjCpf(pageable, cnpjcpf));
    }

    @GetMapping(value={"/validaCpfCnpj/{cnpjcpf}"})
    public Boolean validaCpfCnpj(@PathVariable(value="cnpjcpf") String cnpjcpf) {
        return this.pessoaDuplicatesService.validaCpfCnpj(cnpjcpf);
    }

    @RequestMapping(method={RequestMethod.PATCH}, value={"/{id}"}, consumes={"application/json-patch+json"})
    public ResponseEntity<Pessoa> patch(@RequestBody List<JsonUpdatePartial> updates, @PathVariable(value="id") Long id, Authentication authentication) {
        Pessoa found = (Pessoa)this.getService().findOne((Serializable)id);
        if (found == null) {
            throw RestException.notFound();
        }
        this.beforePatch((EloEntity)found, updates);
        found.setEnviaParaEsocial(Boolean.valueOf(this.getPessoaService().enviarPessoaParaEsocial(found, updates)));
        this.beforeApplyPatch((EloEntity)found, authentication);
        return ResponseEntity.ok((Object)((Pessoa)this.getCrudService().applyPartialUpdateAndSave((EloEntity)found, MetaModelLoader.newMetaModel(Pessoa.class), updates, authentication)));
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/pessoaDisableDuplicate"})
    public ResponseEntity<Void> postPessoaDisableDuplicate(@RequestBody @Valid PessoaDisableDuplicate pessoaDisableDuplicate) {
        this.pessoaDuplicatesService.savePessoaDisableDuplicate(pessoaDisableDuplicate);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).build();
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/{id}/disable"})
    public ResponseEntity<Void> inativarPessoa(@PathVariable(value="id") Long id) {
        this.pessoaDuplicatesService.inativarPessoa(id);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).build();
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/pessoaDisableDuplicate"})
    public ResponseEntity<Page<PessoaDisableDuplicate>> getPageablePessoaDisableDuplicate(@RequestParam(value="search", required=false) String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.pessoaDisableDuplicates.findAll(RsqlUtils.createSpecFrom((EntityManager)this.getService().getEm(), (String)search), pageable));
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/pessoaDisableDuplicate/model"})
    public ResponseEntity<MetaModel> getModelPessoaDisableDuplicate(@RequestParam(value="fields") String fields) {
        return ResponseEntity.ok((Object)MetaModelLoader.newMetaModel(PessoaDisableDuplicate.class, (List)Splitter.on((String)",").omitEmptyStrings().trimResults().splitToList((CharSequence)fields)));
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{id}/refresh"})
    public ResponseEntity<Pessoa> refresh(@PathVariable(value="id") Long id, Authentication authentication) {
        return ResponseEntity.ok((Object)this.getPessoaService().saveSkippingValidation((Pessoa)this.getService().findOne((Serializable)id), authentication));
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/template"})
    public ResponseEntity<Pessoa> template() {
        Pessoa pessoaTemplate = new Pessoa();
        this.enableScopeByModulo(pessoaTemplate);
        return ResponseEntity.ok((Object)pessoaTemplate);
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{id}/enableByModulo"})
    public ResponseEntity<Pessoa> enableByModulo(@PathVariable(value="id") Long id, Authentication authentication) {
        Pessoa pessoa = (Pessoa)this.getService().findOne((Serializable)id);
        this.enableScopeByModulo(pessoa);
        Pessoa saved = this.getPessoaService().saveSkippingValidation(pessoa, authentication);
        return ResponseEntity.ok((Object)saved);
    }

    @GetMapping(value={"/endereco/cep/{cep}"})
    public ResponseEntity<PessoaEndereco> findEnderecoByCep(@PathVariable(value="cep") Long cep) {
        return ResponseEntity.ok((Object)this.getPessoaService().findEnderecoByCep(cep));
    }

    private void enableScopeByModulo(Pessoa pessoa) {
        if (ContextHolder.hasHeadersValue() && !ContextHolder.getHeaderValueModulo().equals((Object)ModuloEnum.MODULO_UNDEFINED)) {
            String fieldContext = ContextHolder.getHeaderValueModulo().getModuloPessoaEscopo().toString().toLowerCase(Locale.getDefault());
            ReflectionUtils.getSetterMethod(Pessoa.class, (String)fieldContext, Boolean.class).invoke((Object)pessoa, true);
        }
    }

    @GetMapping(value={"/ids"})
    public ResponseEntity<List<Pessoa>> findByIdIn(@RequestParam(value="id") List<Long> ids) {
        return ResponseEntity.ok((Object)this.pessoas.findByIdIn(ids));
    }

    @GetMapping(value={"/filter"})
    public ResponseEntity<List<Pessoa>> findAllPessoasByDataCadastroBetween(@RequestParam(name="dataInicial") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate dataInicial, @RequestParam(name="dataFinal") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate dataFinal) {
        return ResponseEntity.ok((Object)((Pessoas)this.getCrudService().getCrudRepository(Pessoas.class)).findByDataCadastroBetween(dataInicial, dataFinal));
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/pessoaDisableDuplicate/{id}"})
    public ResponseEntity<Void> removePessoaDisableDuplicate(@PathVariable(value="id") Long id) {
        PessoaDisableDuplicate pessoaDisableDuplicate = (PessoaDisableDuplicate)this.pessoaDisableDuplicates.findOne((Object)id);
        if (Objects.isNull(pessoaDisableDuplicate)) {
            throw RestException.notFound();
        }
        this.pessoaDuplicatesService.remove(pessoaDisableDuplicate);
        return ResponseEntity.ok().build();
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/pessoaDisableDuplicate/{id}/revert"})
    public ResponseEntity<Void> revertPessoaDisableDuplicate(@PathVariable(value="id") Long id) throws IOException {
        PessoaDisableDuplicate pessoaDisableDuplicate = (PessoaDisableDuplicate)this.pessoaDisableDuplicates.findOne((Object)id);
        if (Objects.isNull(pessoaDisableDuplicate)) {
            throw RestException.notFound();
        }
        this.pessoaDuplicatesService.revert(pessoaDisableDuplicate.getId());
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/{id}/create-user"})
    public ResponseEntity<UsuarioDTO> createUser(@PathVariable(value="id") Long id) {
        return ResponseEntity.ok((Object)this.getPessoaService().createUser(id));
    }

    @GetMapping(value={"/imagem-perfil/{id}"})
    public ResponseEntity<String> getImagemPerfil(@PathVariable(value="id") Long id) {
        return ResponseEntity.ok((Object)this.getPessoaService().getImagemPerfil(id));
    }
}

