/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.resource;

import br.com.elotech.di.domain.Pessoa;
import br.com.elotech.di.domain.dto.PessoaIntegracaoSocialDTO;
import br.com.elotech.di.service.PessoaIntegracaoSocialService;
import br.com.elotech.di.service.PessoaService;
import br.com.elotech.unico.client.dto.ErrorResponse;
import br.com.elotech.unico.client.dto.PessoaDTO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import javax.validation.Valid;
import lombok.Generated;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/integracoes/pessoas"})
public class PessoaIntegracaoResource {
    private final PessoaService pessoaService;
    private final PessoaIntegracaoSocialService pessoaIntegracaoSocialService;

    @GetMapping
    @Operation(summary="Retorna as pessoas do Cadastro \u00danico", description="Retorna as pessoas do Cadastro \u00danico de forma paginada.", responses={@ApiResponse(description="Success", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=PessoaDTO.class))}), @ApiResponse(description="Internal error", responseCode="500", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))})})
    public ResponseEntity<Page<PessoaDTO>> findAll(@Parameter(description="Search query", example="nome==John") @RequestParam(value="search", required=false) String search, @ParameterObject Pageable pageable) {
        return ResponseEntity.ok((Object)this.pessoaService.findByRsql(search, pageable).map(Pessoa::convertToEvent).map(pessoaDTO -> {
            pessoaDTO.getBancosPessoa().clear();
            return pessoaDTO;
        }));
    }

    @PostMapping
    @Operation(summary="Cadastrar ou editar pessoas no Cadastro \u00danico", description="Endpoint para cadastrar ou editar pessoas no Cadastro \u00danico.", responses={@ApiResponse(description="Success", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=PessoaDTO.class))}), @ApiResponse(description="Internal error", responseCode="500", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))})})
    public ResponseEntity<?> save(@io.swagger.v3.oas.annotations.parameters.RequestBody(description="Pessoa integra\u00e7\u00e3o", required=true, content={@Content(schema=@Schema(implementation=PessoaIntegracaoSocialDTO.class))}) @RequestBody @Valid PessoaIntegracaoSocialDTO dto) {
        return ResponseEntity.ok((Object)this.pessoaIntegracaoSocialService.save(dto));
    }

    @Generated
    public PessoaIntegracaoResource(PessoaService pessoaService, PessoaIntegracaoSocialService pessoaIntegracaoSocialService) {
        this.pessoaService = pessoaService;
        this.pessoaIntegracaoSocialService = pessoaIntegracaoSocialService;
    }
}

