/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.resource;

import br.com.elotech.di.domain.Pessoa;
import br.com.elotech.di.domain.dto.GrupoDuplicado;
import br.com.elotech.di.domain.dto.PessoaDuplicadaDTO;
import br.com.elotech.di.unificacao.PessoasDuplicadasService;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/pessoas-unificacao"})
public class PessoaDuplicadaResource {
    private final PessoasDuplicadasService service;

    public PessoaDuplicadaResource(PessoasDuplicadasService service) {
        this.service = service;
    }

    @GetMapping
    public Page<PessoaDuplicadaDTO> duplicadas(Pageable pageable) {
        return this.service.findDuplicadas(pageable);
    }

    @PostMapping
    public ResponseEntity<Pessoa> unificar(@RequestBody @Valid PessoaDuplicadaDTO pessoaDuplicadaDTO) {
        GrupoDuplicado grupoDuplicado = this.service.findGrupo(pessoaDuplicadaDTO.getNomesOriginais(), pessoaDuplicadaDTO.getCnpjCpf());
        Pessoa remaining = this.service.unificar(grupoDuplicado);
        return ResponseEntity.ok((Object)remaining);
    }
}

