/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.resource;

import br.com.elotech.console.dto.Modulo;
import br.com.elotech.di.resource.support.AbstractController;
import br.com.elotech.di.service.ModuloService;
import java.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/modulos"})
public class ModuloResource
extends AbstractController<br.com.elotech.di.domain.Modulo, Long> {
    @Autowired
    private ModuloService moduloService;

    @GetMapping(value={"/nome/{modulo}"})
    public ResponseEntity<String> moduloName(@PathVariable(value="modulo") String modulo) {
        return ResponseEntity.ok((Object)Modulo.valueOf((String)modulo).getDescricao());
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{modulo}/path"})
    public ResponseEntity<String> moduloPath(@PathVariable(value="modulo") String modulo) {
        return ResponseEntity.ok((Object)br.com.elotech.di.domain.Modulo.getPathByModuloEnum((String)modulo));
    }

    @GetMapping(value={"/{modulo}/updateDataAcesso"})
    public ResponseEntity<LocalDateTime> updateDataAcesso(@PathVariable(value="modulo") String modulo) {
        String usuario = SecurityContextHolder.getContext().getAuthentication().getName();
        return ResponseEntity.ok((Object)this.moduloService.updateSiscopLastLogin(usuario, modulo));
    }
}

