/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.resource;

import br.com.elotech.di.domain.Entidade;
import br.com.elotech.di.domain.LeiAto;
import br.com.elotech.di.repository.LeiAtos;
import br.com.elotech.di.resource.support.AbstractController;
import br.com.elotech.di.service.LeiAtoService;
import br.com.elotech.unico.client.dto.PublicacaoOrgaoOficialAMDTO;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/leiatos"})
public class LeiAtoResource
extends AbstractController<LeiAto, Long> {
    private static final Long ID_TIPO_LEI_ESCOPO_DIARIA = 27L;

    public LeiAtoService getCrudService() {
        return (LeiAtoService)super.getCrudService();
    }

    @GetMapping(value={"/filter"})
    public ResponseEntity<List<LeiAto>> findAllLeisAtosByEntidadeAndDataCadastroBetween(@RequestParam(name="entidade") Long idEntidade, @RequestParam(name="dataInicial") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate dataInicial, @RequestParam(name="dataFinal") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate dataFinal) {
        return ResponseEntity.ok((Object)((LeiAtos)this.getCrudService().getCrudRepository(LeiAtos.class)).findByEntidadeAndDataCadastroBetween(Entidade.of((Long)idEntidade), dataInicial, dataFinal));
    }

    @GetMapping(value={"/filter-publicacao-orgao-oficial"})
    public ResponseEntity<List<PublicacaoOrgaoOficialAMDTO>> findAllPublicacaoOrgaoOficialAMDTOByEntidadeDataPublicacaoBetween(@RequestParam(name="entidade") Long idEntidade, @RequestParam(name="dataInicial") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate dataInicial, @RequestParam(name="dataFinal") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate dataFinal) {
        return ResponseEntity.ok((Object)((LeiAtos)this.getCrudService().getCrudRepository(LeiAtos.class)).findAllLeiAtoVeiculoPublicacaoByEntidadeDataPublicacaoBetween(Entidade.of((Long)idEntidade), dataInicial, dataFinal));
    }

    @GetMapping(value={"/codigo-tce"})
    public ResponseEntity<Long> findCodigoTceByAnoEntidadeAndNumeroLei(@RequestParam(name="entidade") Long idEntidade, @RequestParam(name="ano") Long ano, @RequestParam(name="numeroLei") Long numeroLei) {
        Optional leiAto = ((LeiAtos)this.getCrudService().getCrudRepository(LeiAtos.class)).findFirstByAnoAndEntidadeAndNumeroAndIdTceNotNull(ano, Entidade.of((Long)idEntidade), numeroLei);
        return ResponseEntity.ok((Object)leiAto.map(LeiAto::getIdTce).orElse(null));
    }

    @GetMapping(value={"/next-numero-tipo-diaria"})
    public ResponseEntity<Long> findNextNumeroLeiAtoByEntidadeAndTipoDiaria(@RequestParam(name="entidade") Long idEntidade) {
        return ResponseEntity.ok((Object)((LeiAtos)this.getCrudService().getCrudRepository(LeiAtos.class)).findNextNumeroLeiAtoByEntidadeAndTipoLeiEscopo(idEntidade, ID_TIPO_LEI_ESCOPO_DIARIA));
    }

    @Generated
    public LeiAtoResource() {
    }
}

