/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.resource;

import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.di.domain.Grupo;
import br.com.elotech.di.domain.Recurso;
import br.com.elotech.di.domain.Usuario;
import br.com.elotech.di.repository.Recursos;
import br.com.elotech.di.repository.Usuarios;
import java.io.Serializable;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/grupos"})
@Transactional
public class GrupoResource
extends CrudResource<Grupo, Long> {
    private final Recursos recursos;
    private final Usuarios usuarios;

    public GrupoResource(Recursos recursos, Usuarios usuarios) {
        this.recursos = recursos;
        this.usuarios = usuarios;
    }

    private ResponseEntity<Void> operationGrupo(Long idGrupo, Function<Grupo, ResponseEntity<Void>> function) {
        Grupo grupo = (Grupo)this.getService().findOne((Serializable)idGrupo);
        if (grupo == null) {
            return ResponseEntity.notFound().build();
        }
        return function.apply(grupo);
    }

    private ResponseEntity<Void> operationRecurso(Long idGrupo, Long idRecurso, BiFunction<Grupo, Recurso, ResponseEntity<Void>> function) {
        return this.operationGrupo(idGrupo, grupo -> {
            Recurso recurso = (Recurso)this.recursos.findOne((Object)idRecurso);
            if (recurso == null) {
                return ResponseEntity.notFound().build();
            }
            return (ResponseEntity)function.apply((Grupo)grupo, recurso);
        });
    }

    private ResponseEntity<Void> operationUsuario(Long idGrupo, Long idUsuario, BiFunction<Grupo, Usuario, ResponseEntity<Void>> function) {
        return this.operationGrupo(idGrupo, grupo -> {
            Usuario usuario = (Usuario)this.usuarios.findOne((Object)idUsuario);
            if (usuario == null) {
                return ResponseEntity.notFound().build();
            }
            return (ResponseEntity)function.apply((Grupo)grupo, usuario);
        });
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{idGrupo}/recurso/{idRecurso}"})
    public ResponseEntity<Void> removeRecurso(@PathVariable(value="idGrupo") Long idGrupo, @PathVariable(value="idRecurso") Long idRecurso) {
        return this.operationRecurso(idGrupo, idRecurso, (grupo, recurso) -> {
            if (!recurso.getGrupos().contains(grupo)) {
                return ResponseEntity.notFound().build();
            }
            recurso.getGrupos().remove(grupo);
            return ResponseEntity.ok().build();
        });
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{idGrupo}/recurso/{idRecurso}"})
    public ResponseEntity<Void> addRecurso(@PathVariable(value="idGrupo") Long idGrupo, @PathVariable(value="idRecurso") Long idRecurso) {
        return this.operationRecurso(idGrupo, idRecurso, (grupo, recurso) -> {
            recurso.getGrupos().add(grupo);
            return ResponseEntity.ok().build();
        });
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/{idGrupo}/usuario/{idUsuario}"})
    public ResponseEntity<Void> addUsuario(@PathVariable(value="idGrupo") Long idGrupo, @PathVariable(value="idUsuario") Long idUsuario) {
        return this.operationUsuario(idGrupo, idUsuario, (grupo, usuario) -> {
            usuario.getGrupos().add(grupo);
            return ResponseEntity.ok().build();
        });
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{idGrupo}/usuario/{idUsuario}"})
    public ResponseEntity<Void> removeUsuario(@PathVariable(value="idGrupo") Long idGrupo, @PathVariable(value="idUsuario") Long idUsuario) {
        return this.operationUsuario(idGrupo, idUsuario, (grupo, usuario) -> {
            if (!usuario.getGrupos().contains(grupo)) {
                return ResponseEntity.notFound().build();
            }
            usuario.getGrupos().remove(grupo);
            return ResponseEntity.ok().build();
        });
    }
}

