/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.resource;

import br.com.elotech.arquivos.domain.response.ArquivoUrl;
import br.com.elotech.arquivos.domain.support.ContentDisposition;
import br.com.elotech.di.domain.shared.TipoArquivo;
import br.com.elotech.di.exception.EloGeoIntegrationException;
import br.com.elotech.di.service.ArquivoServiceImpl;
import br.com.elotech.di.service.ArquivoStorageServiceImpl;
import br.com.elotech.di.service.LogAcessoApiGeoService;
import br.com.elotech.di.service.TipoArquivoService;
import br.com.elotech.unico.client.domain.TipoArquivoEnum;
import br.com.elotech.unico.client.dto.ArquivoResponseDTO;
import br.com.elotech.unico.client.dto.ErrorResponse;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/geofileslinksdownload"})
public class GeoFilesLinksResource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GeoFilesLinksResource.class);
    private ArquivoServiceImpl arquivoService;
    private TipoArquivoService tipoArquivoService;
    private ArquivoStorageServiceImpl arquivoStorageService;
    private LogAcessoApiGeoService logAcessoApiGeoService;

    @GetMapping(value={"links-files"})
    @Operation(summary="Retorna os links registrados para download dos arquivos das view utilizadas pelo Geo!", description="Retorna um Array com os Links para Download das arquivos do Geo.", responses={@ApiResponse(description="Success", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=ArquivoResponseDTO.class))}), @ApiResponse(description="Internal error", responseCode="500", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))})})
    public ResponseEntity<List<ArquivoResponseDTO>> getLinkFiles(@RequestParam(value="finalidade") String finalidade, HttpServletRequest request) {
        List arquivoResponse;
        TipoArquivo tipoArquivo = this.tipoArquivoService.findByTipo(TipoArquivoEnum.ASYNC_GENERATED);
        log.info("Inicinando busca do arquivos asyncronos. Finalidade: {}", (Object)finalidade);
        List arquivos = this.arquivoService.findArquivoPorTipoArquivoAndFinalidade(tipoArquivo, finalidade);
        if (arquivos.isEmpty()) {
            log.error("Nenhum arquivo encontrado para a finalidade: {}", (Object)finalidade);
            throw new EloGeoIntegrationException(HttpStatus.INTERNAL_SERVER_ERROR, "Nenhum arquivo encontrado para a finalidade: " + finalidade);
        }
        log.info("Iniciando a cria\u00e7\u00e3o do responseDTO");
        try {
            arquivoResponse = arquivos.stream().map(arquivo -> {
                ArquivoUrl arquivoUrl = this.arquivoStorageService.getUrlDownload(arquivo.getFullPath(), arquivo.getNome(), ContentDisposition.ATTACHMENT);
                return ArquivoResponseDTO.builder().nome(arquivo.getNome()).urlSigned(arquivoUrl.getUrlAssinada()).build();
            }).collect(Collectors.toList());
        }
        catch (Exception ex) {
            log.error("Erro ao processar os arquivos para a finalidade {}: {}", new Object[]{finalidade, ex.getMessage(), ex});
            throw new EloGeoIntegrationException(HttpStatus.INTERNAL_SERVER_ERROR, "Erro ao processar os arquivos para a finalidade: " + finalidade);
        }
        this.createLogApiAccess(request, HttpStatus.OK);
        return ResponseEntity.ok(arquivoResponse);
    }

    private void createLogApiAccess(HttpServletRequest request, HttpStatus httpStatus) {
        this.logAcessoApiGeoService.createLogAcessoApiGeo(request.getRequestURI(), httpStatus.toString());
    }

    @ExceptionHandler(value={EloGeoIntegrationException.class})
    public ResponseEntity<ErrorResponse> handleException(EloGeoIntegrationException ex, HttpServletRequest request) {
        ErrorResponse errorResponse = new ErrorResponse(ex.getStatus().toString(), ex.getMessage());
        this.createLogApiAccess(request, HttpStatus.INTERNAL_SERVER_ERROR);
        return new ResponseEntity((Object)errorResponse, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @Generated
    public GeoFilesLinksResource(ArquivoServiceImpl arquivoService, TipoArquivoService tipoArquivoService, ArquivoStorageServiceImpl arquivoStorageService, LogAcessoApiGeoService logAcessoApiGeoService) {
        this.arquivoService = arquivoService;
        this.tipoArquivoService = tipoArquivoService;
        this.arquivoStorageService = arquivoStorageService;
        this.logAcessoApiGeoService = logAcessoApiGeoService;
    }
}

