/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.resource;

import br.com.elotech.di.domain.Feriado;
import br.com.elotech.di.domain.FeriadoDTO;
import br.com.elotech.di.resource.support.AbstractController;
import br.com.elotech.di.service.FeriadoService;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/feriados"})
public class FeriadoResource
extends AbstractController<Feriado, Long> {
    public FeriadoService getCrudService() {
        return (FeriadoService)super.getCrudService();
    }

    @GetMapping(value={"/validar-data-feriado"})
    public ResponseEntity<Boolean> findAllWithSimilarity(@RequestParam(value="dataFeriado") String dataFeriado, @RequestParam(value="cidade", required=false) Optional<Long> cidade) {
        return ResponseEntity.ok((Object)this.getCrudService().validarDataFeriado(LocalDate.parse(dataFeriado), cidade));
    }

    @GetMapping(value={"/findall-dto"})
    public ResponseEntity<Page<FeriadoDTO>> findAllDTO(@RequestParam(value="search", required=false) String search, Pageable pageable) {
        String searchComAnoNulo = "";
        if (Objects.nonNull(search)) {
            searchComAnoNulo = Arrays.stream(search.split("and")).map(c -> {
                if (c.contains("ano")) {
                    return String.format(" (%s or ano==null) ", c);
                }
                return c;
            }).collect(Collectors.joining("and"));
        }
        return ResponseEntity.ok((Object)this.getCrudService().findAll(searchComAnoNulo, pageable));
    }
}

