/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.resource;

import br.com.elotech.di.domain.AppParams;
import br.com.elotech.di.domain.Entidade;
import br.com.elotech.di.resource.support.AbstractController;
import br.com.elotech.di.service.EntidadeService;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.util.Objects;
import java.util.Optional;
import javax.imageio.ImageIO;
import org.apache.tomcat.util.http.fileupload.ByteArrayOutputStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/entidades", "/api/entidades"})
public class EntidadesResource
extends AbstractController<Entidade, Long> {
    @Autowired
    private EntidadeService entidadeService;
    @Autowired
    private AppParams appParams;

    public void setEntidadeService(EntidadeService entidaService) {
        this.entidadeService = entidaService;
    }

    @GetMapping(value={"/tenantId"})
    public String getTenantId() {
        return this.entidadeService.getTenantId();
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/principal/brasao"}, produces={"image/jpeg"})
    public ResponseEntity<?> getBrasaoPrincipal() {
        Optional entidadePrincipal = this.entidadeService.getEntidadePrincipal();
        if (entidadePrincipal.isPresent() && Objects.nonNull(((Entidade)entidadePrincipal.get()).getBrasao())) {
            BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(((Entidade)entidadePrincipal.get()).getBrasao()));
            ByteArrayOutputStream outputJpg = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "jpg", (OutputStream)outputJpg);
            return ResponseEntity.ok((Object)outputJpg.toByteArray());
        }
        return ResponseEntity.noContent().build();
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/principal/entidade"})
    public ResponseEntity<?> getEntidadePrincipal() {
        Optional entidadePrincipal = this.entidadeService.getEntidadePrincipal();
        if (entidadePrincipal.isPresent()) {
            return ResponseEntity.ok((Object)((Entidade)entidadePrincipal.get()));
        }
        return ResponseEntity.noContent().build();
    }

    public boolean disableRemove() {
        return this.appParams.isCloud();
    }

    @GetMapping(value={"/entidade-logada/usa-tributos"})
    public ResponseEntity<Boolean> usaTributos() {
        return ResponseEntity.ok((Object)this.entidadeService.entidadeLogadaUsaTributos());
    }
}

