/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.resource;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.di.domain.Duplicacao;
import br.com.elotech.di.domain.dto.duplicacao.DuplicadaDTO;
import br.com.elotech.di.domain.enums.DuplicacaoStatus;
import br.com.elotech.di.service.DuplicacaoService;
import br.com.elotech.di.service.PessoaEnderecoAsyncService;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.commons.collections4.ListUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/duplicacoes"})
public class DuplicacaoResource {
    private final DuplicacaoService service;
    private final PessoaEnderecoAsyncService enderecoPessoaService;

    @PostMapping
    public ResponseEntity<Void> saveAllDuplicacoes(@RequestBody List<Duplicacao> duplicacoes) {
        this.service.saveAllDuplicacoes(duplicacoes);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).build();
    }

    @DeleteMapping(value={"/removeWithChavePrincipal/{tabela}/{id}"})
    public ResponseEntity<Void> removeWithChavePrincipal(@PathVariable(value="tabela") String tabela, @PathVariable(value="id") Long id) {
        this.service.removeWithChavePrincipal(tabela, id);
        return ResponseEntity.ok().build();
    }

    @DeleteMapping(value={"/removeWithChaveInativa/{tabela}/{id}"})
    public ResponseEntity<Void> removeWithChaveInativa(@PathVariable(value="tabela") String tabela, @PathVariable(value="id") Long id) {
        this.service.removeWithChaveInativa(tabela, id);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/cidades"})
    public ResponseEntity<Void> unificarCidades() {
        this.unificarDuplicacao(() -> ((DuplicacaoService)this.service).findAllCidadesDuplicadasNotExecutado(), arg_0 -> ((PessoaEnderecoAsyncService)this.enderecoPessoaService).unificarCidade(arg_0));
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).build();
    }

    private void unificarDuplicacao(Supplier<List<DuplicadaDTO>> findAllNotExecutado, Consumer<DuplicadaDTO> unifica) {
        List<DuplicadaDTO> duplicadaDTOS = findAllNotExecutado.get();
        if (duplicadaDTOS.isEmpty()) {
            throw RestException.notFound();
        }
        duplicadaDTOS.forEach(dup -> {
            dup.setStatus(DuplicacaoStatus.PROCESSANDO);
            this.service.updateExecutando(dup.getDuplicacoesIds());
        });
        duplicadaDTOS.forEach(unifica);
    }

    @GetMapping(value={"/cidades/not_executado"})
    public ResponseEntity<List<DuplicadaDTO>> findAllCidadesDuplicadasNotExecutado() {
        return ResponseEntity.ok((Object)ListUtils.union((List)this.service.findAllCidadesDuplicadasExecucao(), (List)this.service.findAllCidadesDuplicadasNotExecutado()));
    }

    @GetMapping(value={"/cidades/executado"})
    public ResponseEntity<List<DuplicadaDTO>> findAllCidadesDuplicadasExecutado() {
        return ResponseEntity.ok((Object)this.service.findAllCidadesDuplicadasExecutado());
    }

    @GetMapping(value={"/logradouros/not_executado"})
    public ResponseEntity<List<DuplicadaDTO>> findAllLogradourosDuplicadasNotExecutado() {
        return ResponseEntity.ok((Object)ListUtils.union((List)this.service.findAllLogradourosDuplicadasExecucao(), (List)this.service.findAllLogradourosDuplicadasNotExecutado()));
    }

    @GetMapping(value={"/logradouros/executado"})
    public ResponseEntity<List<DuplicadaDTO>> findAllLogradourosDuplicadasExecutado() {
        return ResponseEntity.ok((Object)this.service.findAllLogradourosDuplicadasExecutado());
    }

    @PostMapping(value={"/logradouros"})
    public ResponseEntity<Void> unificarLogradouros() {
        this.unificarDuplicacao(() -> ((DuplicacaoService)this.service).findAllLogradourosDuplicadasNotExecutado(), arg_0 -> ((PessoaEnderecoAsyncService)this.enderecoPessoaService).unificarLogradouro(arg_0));
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).build();
    }

    @GetMapping(value={"/bairros/not_executado"})
    public ResponseEntity<List<DuplicadaDTO>> findAllBairrosDuplicadasNotExecutado() {
        return ResponseEntity.ok((Object)ListUtils.union((List)this.service.findAllBairrosDuplicadasExecucao(), (List)this.service.findAllBairrosDuplicadasNotExecutado()));
    }

    @GetMapping(value={"/bairros/executado"})
    public ResponseEntity<List<DuplicadaDTO>> findAllBairrosDuplicadasExecutado() {
        return ResponseEntity.ok((Object)this.service.findAllBairrosDuplicadasExecutado());
    }

    @PostMapping(value={"/bairros"})
    public ResponseEntity<Void> unificarBairros() {
        this.unificarDuplicacao(() -> ((DuplicacaoService)this.service).findAllBairrosDuplicadasNotExecutado(), arg_0 -> ((PessoaEnderecoAsyncService)this.enderecoPessoaService).unificarBairro(arg_0));
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).build();
    }

    @Generated
    public DuplicacaoResource(DuplicacaoService service, PessoaEnderecoAsyncService enderecoPessoaService) {
        this.service = service;
        this.enderecoPessoaService = enderecoPessoaService;
    }
}

