/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.resource;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.json.update.JsonUpdatePartial;
import br.com.elotech.di.domain.Usuario;
import br.com.elotech.di.domain.shared.AssinaturaDigital;
import br.com.elotech.di.resource.support.AbstractController;
import br.com.elotech.di.service.UsuarioLogadoService;
import br.com.elotech.di.service.UsuarioService;
import java.util.List;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/assinaturas-digitais"})
public class AssinaturaDigitalResource
extends AbstractController<AssinaturaDigital, Long> {
    private final UsuarioLogadoService usuarioLogadoService;
    private final UsuarioService usuarioService;

    public AssinaturaDigitalResource(UsuarioLogadoService usuarioLogadoService, UsuarioService usuarioService) {
        this.usuarioLogadoService = usuarioLogadoService;
        this.usuarioService = usuarioService;
    }

    public void beforeSave(AssinaturaDigital entity) {
        this.validaAcessoDoUsuario(entity);
        super.beforeSave((EloEntity)entity);
    }

    public void beforeUpdate(AssinaturaDigital entity) {
        this.validaAcessoDoUsuario(entity);
        super.beforeUpdate((EloEntity)entity);
    }

    public void beforePatch(AssinaturaDigital entity, List<JsonUpdatePartial> updates) {
        this.validaAcessoDoUsuario(entity);
        super.beforePatch((EloEntity)entity, updates);
    }

    private void validaAcessoDoUsuario(AssinaturaDigital entity) {
        Optional.ofNullable(entity.getId()).ifPresent(id -> {
            AssinaturaDigital assinaturaDigital = (AssinaturaDigital)this.getService().getRepository().findOne(id);
            String username = this.usuarioLogadoService.getUsuarioLogado().getUsername();
            Usuario usuarioLogado = this.usuarioService.findByUsuario(username);
            if (!assinaturaDigital.getUsuarioCriacao().equals((Object)usuarioLogado)) {
                throw RestException.notAllowed();
            }
        });
    }
}

