/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.resource;

import br.com.elotech.arquivos.domain.response.ArquivoUrl;
import br.com.elotech.arquivos.domain.support.ContentDisposition;
import br.com.elotech.arquivos.domain.support.ContentType;
import br.com.elotech.console.dto.Modulo;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.di.domain.HashArquivosCloudConfig;
import br.com.elotech.di.domain.shared.TipoArquivoStorageEnum;
import br.com.elotech.di.service.ArquivoStorageServiceImpl;
import br.com.elotech.unico.client.dto.ArquivoDTO;
import java.io.IOException;
import java.util.Optional;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/rest/arquivos-storage"})
public class ArquivoStorageResource {
    private final ArquivoStorageServiceImpl arquivoStorageService;

    public ArquivoStorageResource(ArquivoStorageServiceImpl arquivoStorageService) {
        this.arquivoStorageService = arquivoStorageService;
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<ArquivoDTO> findOne(@PathVariable(value="id") Long id) {
        return ResponseEntity.ok((Object)this.arquivoStorageService.findOne(id));
    }

    @GetMapping(value={"/{id}/with-content"})
    public ResponseEntity<ArquivoDTO> findOneWithContent(@PathVariable(value="id") Long id) {
        return ResponseEntity.ok((Object)this.arquivoStorageService.findOneWithContent(id));
    }

    @GetMapping(value={"/url/upload"})
    public ResponseEntity<ArquivoUrl> getUrlUpload(@RequestParam Modulo modulo, @RequestParam String filePath, @RequestParam String fileName, @RequestParam String contentType) {
        ContentType contentTypeArquivo = StringUtils.isEmpty((CharSequence)contentType) ? ContentType.fromExtension((String)fileName) : ContentType.fromType((String)contentType);
        return ResponseEntity.ok((Object)this.arquivoStorageService.getUrlUpload(modulo, filePath, fileName, contentTypeArquivo));
    }

    @GetMapping(value={"/url/upload-unico"})
    public ResponseEntity<ArquivoUrl> getUrlUploadUnico(@RequestParam Long tipo, @RequestParam String fileName, @RequestParam String contentType) {
        TipoArquivoStorageEnum tipoArquivoStorage = Optional.ofNullable(TipoArquivoStorageEnum.fromValue((Long)tipo)).orElseThrow(RestException::notFound);
        return ResponseEntity.ok((Object)this.arquivoStorageService.getUrlUploadUnico(tipoArquivoStorage, fileName, ContentType.fromType((String)contentType)));
    }

    @GetMapping(value={"/url/download"})
    public ResponseEntity<ArquivoUrl> getUrlDownload(@RequestParam String fullPath, @RequestParam String fileName, @RequestParam(required=false) String tenant) {
        return ResponseEntity.ok((Object)this.arquivoStorageService.getUrlDownload(fullPath, fileName, tenant, ContentDisposition.ATTACHMENT));
    }

    @GetMapping(value={"/url/display"})
    public ResponseEntity<ArquivoUrl> getUrlDisplay(@RequestParam String fullPath, @RequestParam String fileName) {
        return ResponseEntity.ok((Object)this.arquivoStorageService.getUrlDownload(fullPath, fileName, ContentDisposition.INLINE));
    }

    @PostMapping(consumes={"application/json"})
    public ResponseEntity<ArquivoDTO> create(@Valid @RequestBody ArquivoDTO arquivo) {
        return ResponseEntity.ok((Object)this.arquivoStorageService.create(arquivo));
    }

    @PostMapping(consumes={"multipart/form-data"})
    public ResponseEntity<ArquivoDTO> createWithFile(@RequestPart(value="arquivo") ArquivoDTO arquivo, @RequestPart(value="file") MultipartFile file) throws IOException {
        return ResponseEntity.ok((Object)this.arquivoStorageService.createWithFile(arquivo, file));
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<ArquivoDTO> update(@PathVariable(value="id") Long id, @RequestBody ArquivoDTO arquivo) {
        return ResponseEntity.ok((Object)this.arquivoStorageService.update(id, arquivo));
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Boolean> update(@PathVariable(value="id") Long id) {
        this.arquivoStorageService.delete(id);
        return ResponseEntity.ok((Object)true);
    }

    @GetMapping(value={"/utilizaCloud"})
    public ResponseEntity<Boolean> getUtilizaCloud() {
        return ResponseEntity.ok((Object)this.arquivoStorageService.utilizaCloud());
    }

    @GetMapping(value={"/atualizaConfigCloud"})
    public ResponseEntity<HashArquivosCloudConfig> getAtualizaConfigCloud() {
        return ResponseEntity.ok((Object)this.arquivoStorageService.atualizaConfigCloud());
    }
}

