/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.resource;

import br.com.elotech.arquivos.domain.response.ArquivoContent;
import br.com.elotech.arquivos.domain.support.ContentType;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.utils.web.ResponseUtils;
import br.com.elotech.di.domain.PDFDetails;
import br.com.elotech.di.domain.shared.Arquivo;
import br.com.elotech.di.domain.shared.AssinaturaDigital;
import br.com.elotech.di.repository.Arquivos;
import br.com.elotech.di.resource.support.AbstractController;
import br.com.elotech.di.service.ArquivoServiceImpl;
import br.com.elotech.di.service.ArquivoStorageServiceImpl;
import br.com.elotech.di.service.AssinaturaDigitalService;
import br.com.elotech.di.utils.ArquivoAssinaturaUtils;
import br.com.elotech.unico.client.dto.EloArquivoContentDTO;
import br.com.elotech.utils.pdf.sign.PdfSignerUtil;
import br.com.elotech.utils.pdf.sign.PdfStamper;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@RestController
@RequestMapping(value={"/rest/arquivos"})
public class ArquivoResource
extends AbstractController<Arquivo, Long> {
    private final ObjectMapper mapper;
    private final ArquivoStorageServiceImpl storage;
    private final AssinaturaDigitalService assinaturaDigitalService;
    private final Arquivos arquivos;
    private final ArquivoServiceImpl arquivoService;
    private final Integer tamanhoMaximo;

    public ArquivoResource(ObjectMapper mapper, ArquivoStorageServiceImpl storage, AssinaturaDigitalService assinaturaDigitalService, Arquivos arquivos, ArquivoServiceImpl arquivoService, @Value(value="${elotech.arquivo.tamanhomaximo}") Integer tamanhoMaximo) {
        this.mapper = mapper;
        this.storage = storage;
        this.assinaturaDigitalService = assinaturaDigitalService;
        this.arquivos = arquivos;
        this.arquivoService = arquivoService;
        this.tamanhoMaximo = tamanhoMaximo;
    }

    @GetMapping(value={"ids"})
    public ResponseEntity<List<Arquivo>> getByIdIn(@RequestParam(value="id") List<Long> ids) {
        if (Objects.isNull(ids)) {
            return ResponseEntity.ok(new ArrayList());
        }
        return ResponseEntity.ok((Object)this.arquivos.findByIdIn(ids));
    }

    @GetMapping(value={"/tamanho-maximo"})
    public ResponseEntity<Integer> getTamanhoMaximo() {
        return ResponseEntity.ok((Object)this.tamanhoMaximo);
    }

    @GetMapping(value={"/search-not-other-solicitacoes"})
    public ResponseEntity<Page<Arquivo>> findAllWithMovimento(@RequestParam(value="search", required=false) String search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.arquivoService.findByRsqlAndNotInOtherSolicitacao(search, pageable));
    }

    @GetMapping(value={"/download/{id}"})
    public void download(@PathVariable(value="id") Long id, HttpServletResponse response) {
        Arquivo arquivo = (Arquivo)this.getCrudService().findOne((Serializable)id);
        if (!(Objects.nonNull(arquivo) && Objects.nonNull(arquivo.getContent()) && Objects.nonNull(arquivo.getContent().getBinary()))) {
            throw RestException.notFound((String)"File not found!");
        }
        ResponseUtils.writePdfToResponse((HttpServletResponse)response, (byte[])arquivo.getContent().getBinary(), (String)arquivo.getNome());
    }

    @PostMapping(consumes={"multipart/form-data"})
    public ResponseEntity<Long> addFile(@RequestParam(value="files") MultipartFile file, @RequestParam(value="dataCriacao") String dataCriacao, Authentication authentication) {
        Arquivo arquivo = new Arquivo();
        arquivo.setDataCriacao((LocalDate)this.mapper.convertValue((Object)dataCriacao, LocalDate.class));
        arquivo.setNome(file.getOriginalFilename());
        arquivo.getContent().setBinary(file.getBytes());
        this.getCrudService().save((EloEntity)arquivo, authentication);
        return ResponseEntity.created((URI)ServletUriComponentsBuilder.fromCurrentRequest().path("/{id}").buildAndExpand(new Object[]{arquivo.getId()}).toUri()).body((Object)arquivo.getId());
    }

    @GetMapping(path={"previewpdfdetails"})
    public ResponseEntity<PDFDetails> carregarPreviaArquivoDetalhes(@RequestParam(value="idArquivo") Long idArquivo, @RequestParam(value="page") Integer page) {
        Arquivo arquivo = (Arquivo)this.getCrudService().findOne((Serializable)idArquivo);
        byte[] pdf = IOUtils.toByteArray((InputStream)this.storage.buscarArquivo(arquivo.getFullPathOriginal()).getContent());
        PdfStamper pdfStamper = PdfStamper.builder().pdfInput(pdf).build();
        PDFDetails pdfDetails = new PDFDetails(Float.valueOf(pdfStamper.getPdfWidth(page.intValue())), Float.valueOf(pdfStamper.getPdfHeight(page.intValue())), Boolean.valueOf(pdfStamper.isPdfRotate(page.intValue())), Integer.valueOf(pdfStamper.getPdfTotalPages()));
        return ResponseEntity.ok((Object)pdfDetails);
    }

    @GetMapping(path={"previewpdf"})
    public ResponseEntity<byte[]> carregarPreviaArquivoPdf(@RequestParam(value="idArquivo") Long idArquivo, @RequestParam(value="page") Integer page) {
        Arquivo arquivo = (Arquivo)this.getCrudService().findOne((Serializable)idArquivo);
        byte[] pdf = IOUtils.toByteArray((InputStream)this.storage.buscarArquivo(arquivo.getFullPath()).getContent());
        return ResponseEntity.ok((Object)PdfStamper.builder().pdfInput(pdf).build().getPageAsImage(page));
    }

    @GetMapping(path={"previewpng"})
    public ResponseEntity<byte[]> carregarPreviaArquivoPng(@RequestParam(value="idAssinatura") Long id) {
        AssinaturaDigital arquivo = this.assinaturaDigitalService.findOne(id);
        return ResponseEntity.ok((Object)arquivo.getArquivo().getContent().getBinary());
    }

    @GetMapping(path={"previewtexto"})
    public ResponseEntity<byte[]> carregarPreviaTextoPng(@RequestParam(value="texto") String texto, @RequestParam(value="font", required=false) Optional<String> font, @RequestParam(value="fontSize", required=false) Optional<Integer> fontSize) {
        return ResponseEntity.ok((Object)PdfStamper.builder().build().getTextAsImage(texto, fontSize, font));
    }

    @GetMapping(path={"previewtextodetails"})
    public ResponseEntity<PDFDetails> carregarPreviaTextoPngDetails(@RequestParam(value="texto") String texto, @RequestParam(value="font", required=false) Optional<String> font, @RequestParam(value="fontSize", required=false) Optional<Integer> fontSize) {
        PdfStamper pdfStamper = PdfStamper.builder().build();
        pdfStamper.getTextAsImage(texto, fontSize, font);
        PDFDetails pdfDetails = new PDFDetails(Float.valueOf(PdfSignerUtil.getTextAsImageWidth((String)texto, fontSize, font)), Float.valueOf(PdfSignerUtil.getTextAsImageHeight(fontSize, font)), null, null);
        return ResponseEntity.ok((Object)pdfDetails);
    }

    @PostMapping(path={"arquivo-autenticidade"})
    public ResponseEntity<Void> adicionarCodigoAutenticidadeIfNotPresent(@RequestParam(value="id") Long idArquivo) {
        Arquivo arquivo = (Arquivo)this.arquivoService.findOne((Serializable)idArquivo);
        if (Objects.isNull(arquivo.getCodigoAutenticidade())) {
            ArquivoContent content = this.storage.buscarArquivo(arquivo.getFullPath());
            byte[] autenticidade = this.arquivoService.adicionarCodigoAutenticidade(arquivo, IOUtils.toByteArray((InputStream)content.getContent()));
            this.storage.updateArquivo(ContentType.APPLICATION_PDF.getValue(), (InputStream)new ByteArrayInputStream(autenticidade), arquivo.getNome().trim(), ArquivoAssinaturaUtils.getFilePath((Arquivo)arquivo), arquivo.getFullPath(), arquivo.getModulo());
        }
        return ResponseEntity.ok().build();
    }

    @PostMapping(path={"mark-signed/{id}"})
    public ResponseEntity<Void> markAsSigned(@PathVariable(value="id") Long idArquivo) {
        this.arquivoService.markAsSigned(idArquivo);
        return ResponseEntity.ok().build();
    }

    @GetMapping(path={"/foto/{pessoaId}"})
    public ResponseEntity<EloArquivoContentDTO> getFotoByPessoaId(@PathVariable(value="pessoaId") Long pessoaId) {
        return ResponseEntity.ok((Object)this.arquivoService.getFotoByPessoaId(pessoaId));
    }
}

