/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.resource;

import br.com.elotech.di.domain.dto.assinatura.AssinaturaCarimboDTO;
import br.com.elotech.di.domain.dto.assinatura.AssinaturaCertificadoA1DTO;
import br.com.elotech.di.domain.dto.assinatura.AssinaturaTextoDTO;
import br.com.elotech.di.service.EnvelopeService;
import java.io.IOException;
import javax.validation.Valid;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/arquivoassinaturas"})
public class ArquivoAssinaturaResource {
    private final EnvelopeService envelopeService;

    @PostMapping(value={"/assinar-carimbo"})
    public ResponseEntity<Void> assinarCarimbo(@Valid @RequestBody AssinaturaCarimboDTO dto) {
        this.envelopeService.assinar(dto);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/assinar-texto"})
    public ResponseEntity<Void> assinarTexto(@Valid @RequestBody AssinaturaTextoDTO dto) {
        this.envelopeService.assinar(dto);
        return ResponseEntity.ok().build();
    }

    @PostMapping(value={"/assinar-certificado"})
    public ResponseEntity<Void> assinarCertificadoA1(@Valid @RequestBody AssinaturaCertificadoA1DTO dto) throws IOException {
        this.envelopeService.assinar(dto);
        return ResponseEntity.ok().build();
    }

    @Generated
    public ArquivoAssinaturaResource(EnvelopeService envelopeService) {
        this.envelopeService = envelopeService;
    }
}

