/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.repository;

import br.com.elotech.di.domain.Usuario;
import br.com.elotech.di.repository.UsuariosLDAP;
import br.com.elotech.di.security.LdapConfigurationProperties;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.query.ContainerCriteria;
import org.springframework.ldap.query.LdapQuery;
import org.springframework.ldap.query.LdapQueryBuilder;
import org.springframework.stereotype.Repository;

@Repository
@ConditionalOnProperty(name={"ldap.enabled"}, havingValue="true", matchIfMissing=false)
public class UsuariosLDAP {
    @Autowired
    private LdapTemplate ldapTemplate;
    @Autowired
    private LdapConfigurationProperties properties;

    public List<Usuario> getAllPersons() {
        return this.searchWithQuery(this.createQuery());
    }

    private ContainerCriteria createQuery() {
        return LdapQueryBuilder.query().where("objectclass").is("person");
    }

    public Page<Usuario> search(Pageable pageable) {
        return this.search(pageable, null);
    }

    public Page<Usuario> search(Pageable pageable, String userFilterLike) {
        ContainerCriteria query = this.createQuery();
        if (userFilterLike != null) {
            query.and(this.properties.getFields().getUsuario()).like(userFilterLike + "*");
        }
        List usuarios = this.ldapTemplate.search((LdapQuery)query, (ContextMapper)new PersonContextMapper(this));
        int recordCount = usuarios.size();
        List usuariosPageContent = usuarios.parallelStream().filter(i -> i != null).collect(Collectors.toList());
        return new PageImpl(usuariosPageContent, pageable, (long)recordCount);
    }

    private List<Usuario> searchWithQuery(ContainerCriteria containerCriteria) {
        return this.ldapTemplate.search((LdapQuery)containerCriteria, (ContextMapper)new PersonContextMapper(this));
    }
}

