/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.repository;

import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.di.domain.Pessoa;
import br.com.elotech.di.repository.projection.PessoaExistsProjection;
import br.com.elotech.di.repository.support.UnicoCrudRepository;
import java.time.LocalDate;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface Pessoas
extends UnicoCrudRepository<Pessoa, Long> {
    public static final String SELECT_DUPLICATE = "select p.tipoPessoa as tipoPessoa, p.cnpjCpf as cnpjCpf, count(*) as quantidade from Pessoa p  where p.inativo = 'N' and p.cnpjCpf is not null";
    public static final String GROUP_DUPLICATEGROUP_DUPLICATE = " group by p.tipoPessoa, p.cnpjCpf having count(*) > 1 order by count(*) desc, p.tipoPessoa";

    @Query(value="select p.tipoPessoa as tipoPessoa, p.cnpjCpf as cnpjCpf, count(*) as quantidade from Pessoa p  where p.inativo = 'N' and p.cnpjCpf is not null group by p.tipoPessoa, p.cnpjCpf having count(*) > 1 order by count(*) desc, p.tipoPessoa")
    public Page<Object> findDuplicates(Pageable var1);

    @Query(value="select p.tipoPessoa as tipoPessoa, p.cnpjCpf as cnpjCpf, count(*) as quantidade from Pessoa p  where p.inativo = 'N' and p.cnpjCpf is not null and p.cnpjCpf like ?1% group by p.tipoPessoa, p.cnpjCpf having count(*) > 1 order by count(*) desc, p.tipoPessoa")
    public Page<Object> findDuplicatesByCnpjCpfLike(Pageable var1, String var2);

    @Query(value="SELECT p FROM Pessoa p where FNC_SOMENTENUMEROS(p.cnpjCpf) = :cnpjCpf and p.inativo = :inativo")
    public Page<PessoaExistsProjection> findByCnpjCpfLikeAndInativo(Pageable var1, String var2, Boolean var3);

    @Query(value="from Pessoa where inativo = 'N' and tipoPessoa = ?1 and cnpjCpf=?2")
    public List<Pessoa> findByTipoPessoaAndCnpjCpf(TipoPessoa var1, String var2);

    @Query(value="from Pessoa where inativo = 'N' and cnpjCpf=?1")
    public List<Pessoa> findByCnpjCpf(String var1);

    @Query(value="SELECT p  FROM Pessoa p  WHERE p.dataCadastro  >= :dataInicial    AND p.dataCadastro  <= :dataFinal ")
    public List<Pessoa> findByDataCadastroBetween(@Param(value="dataInicial") LocalDate var1, @Param(value="dataFinal") LocalDate var2);

    @Query(value=" select distinct p from Pessoa p inner join p.enderecos ep  inner join ep.endereco.cidade c where c.id in (:idsCidade)")
    public List<Pessoa> findByPessoaEnderecoCidadeIdIn(@Param(value="idsCidade") List<Long> var1);

    @Query(value=" select distinct p from Pessoa p inner join p.enderecos ep  inner join ep.endereco.logradouro c where c.id in (:idsLogradouro)")
    public List<Pessoa> findByPessoaEnderecoLogradouroIdIn(@Param(value="idsLogradouro") List<Long> var1);

    @Query(value=" select distinct p from Pessoa p inner join p.enderecos ep  inner join ep.endereco.bairro c where c.id in (:idsBairro)")
    public List<Pessoa> findByPessoaEnderecoBairroIdIn(@Param(value="idsBairro") List<Long> var1);
}

