/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.repository;

import br.com.elotech.di.domain.Entidade;
import br.com.elotech.di.domain.LeiAto;
import br.com.elotech.di.repository.support.UnicoCrudRepository;
import br.com.elotech.unico.client.dto.PublicacaoOrgaoOficialAMDTO;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface LeiAtos
extends UnicoCrudRepository<LeiAto, Long> {
    @Query(value="SELECT l  FROM LeiAto l  WHERE l.dataCadastro  >= :dataInicial    AND l.dataCadastro  <= :dataFinal    AND l.entidade = :entidade")
    public List<LeiAto> findByEntidadeAndDataCadastroBetween(@Param(value="entidade") Entidade var1, @Param(value="dataInicial") LocalDate var2, @Param(value="dataFinal") LocalDate var3);

    @Query(value="SELECT new br.com.elotech.unico.client.dto.PublicacaoOrgaoOficialAMDTO(        a.idTce,        b.dataPublicacao,        c.codigoOperacao,        a.atoPessoal )  FROM LeiAto a   INNER JOIN a.publicacoes b   INNER JOIN b.veiculoPublicacao c WHERE a.entidade = :entidade    AND b.dataPublicacao BETWEEN :dataInicial AND :dataFinal  ORDER BY b.dataPublicacao asc")
    public List<PublicacaoOrgaoOficialAMDTO> findAllLeiAtoVeiculoPublicacaoByEntidadeDataPublicacaoBetween(@Param(value="entidade") Entidade var1, @Param(value="dataInicial") LocalDate var2, @Param(value="dataFinal") LocalDate var3);

    @Query(value="SELECT max(l.idTce)   FROM LeiAto l    WHERE l.entidade = :entidade")
    public Long findMaxIdTceByEntidade(@Param(value="entidade") Entidade var1);

    public List<LeiAto> findByEntidadeAndIdTce(Entidade var1, Long var2);

    public Optional<LeiAto> findFirstByAnoAndEntidadeAndNumeroAndIdTceNotNull(@Param(value="ano") Long var1, @Param(value="entidade") Entidade var2, @Param(value="numeroLei") Long var3);

    @Query(value="SELECT coalesce(max(l.numero), 0) + 1    FROM LeiAto l   JOIN l.entidade e   JOIN l.tipoLeiEscopo t  WHERE e.id = :entidade    AND t.id = :tipoLeiEscopo ")
    public Long findNextNumeroLeiAtoByEntidadeAndTipoLeiEscopo(@Param(value="entidade") Long var1, @Param(value="tipoLeiEscopo") Long var2);
}

