/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.repository;

import br.com.elotech.core.repository.support.CrudRepository;
import br.com.elotech.di.domain.Duplicacao;
import br.com.elotech.di.domain.dto.duplicacao.DuplicadaDTO;
import br.com.elotech.di.domain.enums.DuplicacaoStatus;
import java.util.List;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface DuplicacaoRepository
extends CrudRepository<Duplicacao, Long> {
    @Query(value="select new br.com.elotech.di.domain.dto.duplicacao.DuplicadaDTO( d.id, d.chaveInativa, d.chavePrincipal,  concat(ci.descricao,' - ',ufp.sigla), concat(cp.descricao,' - ',ufp.sigla), d.status, d.erro) from Duplicacao d  left join Cidade ci on ci.id = d.chaveInativa left join Cidade cp on cp.id = d.chavePrincipal left join cp.uf ufp  where d.tabela = 'cidade' AND d.status in (:statusIn)")
    public List<DuplicadaDTO> findAllCidadesDuplicadasByStatusIn(@Param(value="statusIn") List<DuplicacaoStatus> var1);

    @Modifying
    @Query(value="update Duplicacao set status = br.com.elotech.di.domain.enums.DuplicacaoStatus.PROCESSADO, erro = null  where id in (:idsDuplicacoes)")
    public void updateExecutadoByIdIn(@Param(value="idsDuplicacoes") List<Long> var1);

    @Modifying
    @Query(value="delete from Duplicacao where tabela = :tabela and chavePrincipal = :chavePrincipal")
    public int removeWithChavePrincipal(@Param(value="tabela") String var1, @Param(value="chavePrincipal") Long var2);

    @Modifying
    @Query(value="delete from Duplicacao where tabela = :tabela and chaveInativa = :chaveInativa")
    public int removeWithChaveInativa(@Param(value="tabela") String var1, @Param(value="chaveInativa") Long var2);

    @Modifying
    @Query(value="update Duplicacao set status = br.com.elotech.di.domain.enums.DuplicacaoStatus.PROCESSANDO, erro = null   where id in (:idsDuplicacoes)")
    public void updateExecutandoByIdIn(@Param(value="idsDuplicacoes") List<Long> var1);

    @Modifying
    @Query(value="update Duplicacao set status = br.com.elotech.di.domain.enums.DuplicacaoStatus.FALHA, erro = :erro   where id in (:idsDuplicacoes)")
    public void updateFalhaByIdIn(@Param(value="idsDuplicacoes") List<Long> var1, @Param(value="erro") String var2);

    @Query(value="select new br.com.elotech.di.domain.dto.duplicacao.DuplicadaDTO( d.id, d.chaveInativa, d.chavePrincipal,  concat(li.descricao,' - ',ci.descricao,' - ', ufp.sigla),  concat(lp.descricao,' - ',cp.descricao,' - ', ufp.sigla), d.status, d.erro) from Duplicacao d  left join Logradouro li on li.id = d.chaveInativa left join Logradouro lp on lp.id = d.chavePrincipal left join lp.cidade cp left join li.cidade ci left join cp.uf ufp  where d.tabela = 'logradouro' AND d.status in (:statusIn)")
    public List<DuplicadaDTO> findAllLogradourosDuplicadasByStatusIn(@Param(value="statusIn") List<DuplicacaoStatus> var1);

    @Query(value="select new br.com.elotech.di.domain.dto.duplicacao.DuplicadaDTO( d.id, d.chaveInativa, d.chavePrincipal,  concat(bi.descricao,' - ',ci.descricao,' - ', ufp.sigla),  concat(bp.descricao,' - ',cp.descricao,' - ', ufp.sigla), d.status, d.erro) from Duplicacao d  left join Bairro bi on bi.id = d.chaveInativa left join Bairro bp on bp.id = d.chavePrincipal left join bp.cidade cp left join bi.cidade ci left join cp.uf ufp  where d.tabela = 'bairro' AND d.status in (:statusIn)")
    public List<DuplicadaDTO> findAllBairrosDuplicadosByStatusIn(@Param(value="statusIn") List<DuplicacaoStatus> var1);
}

