/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.repository;

import br.com.elotech.core.repository.support.CrudRepository;
import br.com.elotech.di.domain.shared.Arquivo;
import br.com.elotech.di.domain.shared.TipoArquivo;
import br.com.elotech.unico.client.dto.EloArquivoContentDTO;
import feign.Param;
import java.io.ByteArrayInputStream;
import java.util.List;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

@Repository
public interface Arquivos
extends CrudRepository<Arquivo, Long> {
    public List<Arquivo> findByIdIn(List<Long> var1);

    @Query(value="select binary from ArquivoContent where arquivo.id = ?1")
    public ByteArrayInputStream getContentAsInputStream(Long var1);

    @Query(value=" select count(a.id) > 0  from Arquivo a join a.content ac where ac.id = ?1 and ac.binary is not null")
    public Boolean hasContent(Long var1);

    @Query(value="select new br.com.elotech.unico.client.dto.EloArquivoContentDTO(ac.binary, a.mimeType) from Pessoa p join p.imagens pi join Arquivo a  on pi.arquivo.id = a.id join ArquivoContent ac  on a.id = ac.id where p.id = :pessoaId  and pi.principal is true ")
    public EloArquivoContentDTO getFotoByPessoaId(@Param(value="pessoaId") Long var1);

    @Query(value="SELECT a FROM Arquivo a WHERE a.id IN (    SELECT MAX(x.id) FROM Arquivo x     WHERE x.tipo = :tipo AND x.fullPath like concat('%/',:finalidade,'/%')     GROUP BY SUBSTRING(x.fullPath, 0, LENGTH(x.fullPath) - (LOCATE('/', REVERSE(x.fullPath)) - 1)))")
    public List<Arquivo> findByTipoAndFinalidade(@Param(value="tipo") TipoArquivo var1, @Param(value="finalidade") String var2);
}

