/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.replicate.support;

import br.com.elotech.di.domain.Usuario;
import br.com.elotech.di.domain.UsuarioEntidade;
import br.com.elotech.di.domain.UsuarioModulo;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class UsuarioMerger {
    public Usuario merge(Usuario original, Usuario other) {
        this.mergeEntidades(original, other);
        this.mergeModulos(original, other);
        this.mergeGrupos(original, other);
        if (StringUtils.isBlank((String)original.getCargo())) {
            original.setCargo(other.getCargo());
        }
        if (StringUtils.isBlank((String)original.getEmail())) {
            original.setEmail(other.getEmail());
        }
        if (StringUtils.isBlank((String)original.getMatricula())) {
            original.setMatricula(other.getMatricula());
        }
        if (StringUtils.isBlank((String)original.getNome())) {
            original.setNome(other.getNome());
        }
        if (StringUtils.isBlank((String)original.getSenha())) {
            original.setSenha(other.getSenha());
        }
        if (original.getCpf() == null) {
            original.setCpf(other.getCpf());
        }
        if (original.getRg() == null) {
            original.setRg(other.getRg());
        }
        return original;
    }

    protected void mergeModulos(Usuario original, Usuario other) {
        for (UsuarioModulo usuarioModulo : other.getModulos()) {
            if (!original.getModulos().stream().noneMatch(e -> e.getModulo().equals((Object)usuarioModulo.getModulo()))) continue;
            UsuarioModulo newUsuarioModulo = new UsuarioModulo();
            newUsuarioModulo.setModulo(usuarioModulo.getModulo());
            newUsuarioModulo.setPrincipal(usuarioModulo.getPrincipal());
            original.getModulos().add(newUsuarioModulo);
        }
    }

    protected void mergeEntidades(Usuario original, Usuario other) {
        for (UsuarioEntidade usuarioEntidade : other.getEntidades()) {
            if (!original.getEntidades().stream().noneMatch(e -> e.getEntidade().equals((Object)usuarioEntidade.getEntidade()))) continue;
            UsuarioEntidade newUsuarioEntidade = new UsuarioEntidade();
            newUsuarioEntidade.setEntidade(usuarioEntidade.getEntidade());
            newUsuarioEntidade.setPrincipal(usuarioEntidade.getPrincipal());
            original.getEntidades().add(newUsuarioEntidade);
        }
    }

    protected void mergeGrupos(Usuario original, Usuario other) {
        original.getGrupos().addAll(other.getGrupos());
    }
}

