/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.di.replicate.support;

import br.com.elotech.di.domain.Agencia;
import br.com.elotech.di.domain.Bairro;
import br.com.elotech.di.domain.Banco;
import br.com.elotech.di.domain.Cidade;
import br.com.elotech.di.domain.Logradouro;
import br.com.elotech.di.domain.Pais;
import br.com.elotech.di.domain.TipoLogradouro;
import br.com.elotech.di.domain.UF;
import br.com.elotech.di.domain.support.EloDomain;
import br.com.elotech.di.repository.Agencias;
import br.com.elotech.di.repository.Bairros;
import br.com.elotech.di.repository.Logradouros;
import br.com.elotech.di.repository.TipoLogradouros;
import br.com.elotech.di.service.AgenciaService;
import br.com.elotech.di.service.BairroService;
import br.com.elotech.di.service.CidadeService;
import br.com.elotech.di.service.LogradouroService;
import br.com.elotech.di.service.PaisService;
import br.com.elotech.di.service.TipoLogradouroService;
import br.com.elotech.di.service.UnidadeFederacaoService;
import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReplicatorInvalido {
    @Autowired
    private PaisService paises;
    @Autowired
    private UnidadeFederacaoService unidadesFederacao;
    @Autowired
    private CidadeService cidades;
    @Autowired
    private BairroService bairrosService;
    @Autowired
    private Bairros bairros;
    @Autowired
    private LogradouroService logradourosService;
    @Autowired
    private Logradouros logradouros;
    @Autowired
    private TipoLogradouroService tipologradourosService;
    @Autowired
    private TipoLogradouros tipologradouros;
    @Autowired
    private Agencias agencias;
    @Autowired
    private AgenciaService agenciasService;

    public synchronized Pais createOrGetPaisInvalido() {
        Pais pais = (Pais)this.paises.findOne((Serializable)Pais.PAIS_INVALIDO.getId());
        if (pais == null) {
            pais = (Pais)this.paises.persistAndFlushStateless((EloDomain)Pais.PAIS_INVALIDO);
        }
        return pais;
    }

    public synchronized UF createOrGetUfInvalida() {
        UF uf = (UF)this.unidadesFederacao.findOne((Serializable)UF.UF_INVALIDA.getId());
        if (uf == null) {
            this.createOrGetPaisInvalido();
            uf = (UF)this.unidadesFederacao.persistAndFlushStateless((EloDomain)UF.UF_INVALIDA);
        }
        return uf;
    }

    public Cidade createOrGetCidadeInvalida() {
        return this.internalCreateCidade(Cidade.CIDADE_INVALIDA);
    }

    private synchronized Cidade internalCreateCidade(Cidade cidadeInvalida) {
        Cidade cidade = (Cidade)this.cidades.findOne((Serializable)cidadeInvalida.getId());
        if (cidade == null) {
            this.createOrGetUfInvalida();
            cidade = (Cidade)this.cidades.persistAndFlushStateless((EloDomain)cidadeInvalida);
        }
        return cidade;
    }

    public synchronized Bairro createOrGetBairroInvalido(String descricao, Cidade cidade) {
        Bairro bairro;
        String descricaoBairro = descricao;
        if (StringUtils.isBlank((String)descricaoBairro)) {
            descricaoBairro = "CONVERSAO";
        }
        if ((bairro = this.bairros.findFirstByDescricaoIgnoreCaseAndCidade(descricaoBairro, cidade)) == null) {
            this.internalCreateCidade(cidade);
            return (Bairro)this.bairrosService.persistAndFlushStateless((EloDomain)new Bairro().withCidade(cidade).withDescricao(descricaoBairro).withInativo(Boolean.TRUE));
        }
        return bairro;
    }

    public synchronized Logradouro createOrGetLogradouroInvalido(String descricao, Cidade cidade) {
        Logradouro logradouro;
        String descricaoLogradouro = descricao;
        if (StringUtils.isBlank((String)descricaoLogradouro)) {
            descricaoLogradouro = "CONVERSAO";
        }
        if ((logradouro = this.logradouros.findFirstByDescricaoIgnoreCaseAndCidade(descricaoLogradouro, cidade)) == null) {
            this.internalCreateCidade(cidade);
            return (Logradouro)this.logradourosService.persistAndFlushStateless((EloDomain)new Logradouro().withDescricao(descricaoLogradouro).withCidade(cidade));
        }
        return logradouro;
    }

    public synchronized TipoLogradouro createOrGetTipoLogradouroInvalida() {
        TipoLogradouro tipoLogradouro = (TipoLogradouro)this.tipologradouros.findOne((Object)TipoLogradouro.TIPO_LOGRADOURO_INVALIDA.getId());
        if (tipoLogradouro == null) {
            tipoLogradouro = (TipoLogradouro)this.tipologradourosService.persistAndFlushStateless((EloDomain)TipoLogradouro.TIPO_LOGRADOURO_INVALIDA);
        }
        return tipoLogradouro;
    }

    public synchronized Agencia createOrUpdateAgencia(String codigo, Banco banco, Cidade cidade) {
        String agencia = StringUtils.left((String)codigo, (int)10);
        Agencia unicoAgencia = this.agencias.findOneByCodigoIgnoreCaseAndBanco(agencia, banco);
        if (unicoAgencia == null) {
            unicoAgencia = (Agencia)this.agenciasService.persistAndFlushStateless((EloDomain)new Agencia().withCodigoDescricaoBanco(agencia, agencia, banco).withCidade(cidade));
        } else if (Objects.isNull(unicoAgencia.getCidade()) && !Objects.isNull(cidade)) {
            Long idAgencia = unicoAgencia.getId();
            this.agenciasService.executeOnNewTransaction(em -> {
                Agencia agenciaEdit = (Agencia)em.find(Agencia.class, (Object)idAgencia);
                agenciaEdit.setCidade(cidade);
                this.agenciasService.persistAndFlushStateless((EloDomain)agenciaEdit);
            });
        }
        return unicoAgencia;
    }
}

